package io.fabric8.kubernetes.api.model.extensions;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class IngressRuleFluentImpl<T extends IngressRuleFluent<T>> extends BaseFluent<T> implements IngressRuleFluent<T>{

     String host;     VisitableBuilder<HTTPIngressRuleValue, ?> http;     Map<String, Object> additionalProperties = new HashMap();
public IngressRuleFluentImpl(){
    
}
public IngressRuleFluentImpl( IngressRule instance ){
    this.withHost(instance.getHost()); this.withHttp(instance.getHttp()); 
}

    public String getHost(){
    return this.host;
    }
    public T withHost( String host){
    this.host=host; return (T) this;
    }
    public HTTPIngressRuleValue getHttp(){
    return this.http!=null?this.http.build():null;
    }
    public T withHttp( HTTPIngressRuleValue http){
    if (http!=null){ this.http= new HTTPIngressRuleValueBuilder(http); _visitables.add(this.http);} return (T) this;
    }
    public HttpNested<T> withNewHttp(){
    return new HttpNestedImpl<T>();
    }
    public HttpNested<T> withNewHttpLike( HTTPIngressRuleValue item){
    return new HttpNestedImpl<T>(item);
    }
    public HttpNested<T> editHttp(){
    return withNewHttpLike(getHttp());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
IngressRuleFluentImpl that = (IngressRuleFluentImpl) o;
if (host != null ? !host.equals(that.host) :that.host != null) return false;
if (http != null ? !http.equals(that.http) :that.http != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class HttpNestedImpl<N> extends HTTPIngressRuleValueFluentImpl<HttpNested<N>> implements HttpNested<N>{

        private final HTTPIngressRuleValueBuilder builder;
    
             HttpNestedImpl (){
        this.builder = new HTTPIngressRuleValueBuilder(this);
        }
             HttpNestedImpl ( HTTPIngressRuleValue item){
        this.builder = new HTTPIngressRuleValueBuilder(this, item);
        }
    
            public N and(){
            return (N) IngressRuleFluentImpl.this.withHttp(builder.build());
        }
            public N endHttp(){
            return and();
        }
    
}


}
