package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;

public class RouteStatusFluentImpl<T extends RouteStatusFluent<T>> extends BaseFluent<T> implements RouteStatusFluent<T>{

     List<VisitableBuilder<RouteIngress, ?>> ingress = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public RouteStatusFluentImpl(){
    
}
public RouteStatusFluentImpl( RouteStatus instance ){
    this.withIngress(instance.getIngress()); 
}

    public T addToIngress( RouteIngress ...items){
    for (RouteIngress item : items) {RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.add(builder);this.ingress.add(builder);} return (T)this;
    }
    public T removeFromIngress( RouteIngress ...items){
    for (RouteIngress item : items) {RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.remove(builder);this.ingress.remove(builder);} return (T)this;
    }
    public List<RouteIngress> getIngress(){
    return build(ingress);
    }
    public T withIngress( List<RouteIngress> ingress){
    this.ingress.clear();if (ingress != null) {for (RouteIngress item : ingress){this.addToIngress(item);}} return (T) this;
    }
    public T withIngress( RouteIngress ...ingress){
    this.ingress.clear(); if (ingress != null) {for (RouteIngress item :ingress){ this.addToIngress(item);}} return (T) this;
    }
    public IngressNested<T> addNewIngres(){
    return new IngressNestedImpl<T>();
    }
    public IngressNested<T> addNewIngresLike( RouteIngress item){
    return new IngressNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RouteStatusFluentImpl that = (RouteStatusFluentImpl) o;
if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class IngressNestedImpl<N> extends RouteIngressFluentImpl<IngressNested<N>> implements IngressNested<N>{

        private final RouteIngressBuilder builder;
    
             IngressNestedImpl (){
        this.builder = new RouteIngressBuilder(this);
        }
             IngressNestedImpl ( RouteIngress item){
        this.builder = new RouteIngressBuilder(this, item);
        }
    
            public N and(){
            return (N) RouteStatusFluentImpl.this.addToIngress(builder.build());
        }
            public N endIngres(){
            return and();
        }
    
}


}
