package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class TagImageHookBuilder extends TagImageHookFluentImpl<TagImageHookBuilder> implements VisitableBuilder<TagImageHook,TagImageHookBuilder>{

     TagImageHookFluent<?> fluent;
public TagImageHookBuilder(){
    this(new TagImageHook());
}
public TagImageHookBuilder( TagImageHookFluent<?> fluent ){
    this(fluent, new TagImageHook());
}
public TagImageHookBuilder( TagImageHookFluent<?> fluent , TagImageHook instance ){
    this.fluent = fluent; fluent.withContainerName(instance.getContainerName()); fluent.withTo(instance.getTo()); 
}
public TagImageHookBuilder( TagImageHook instance ){
    this.fluent = this; this.withContainerName(instance.getContainerName()); this.withTo(instance.getTo()); 
}

public TagImageHook build(){
    TagImageHook buildable = new TagImageHook(fluent.getContainerName(),fluent.getTo());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
TagImageHookBuilder that = (TagImageHookBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
