package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class TagReferenceBuilder extends TagReferenceFluentImpl<TagReferenceBuilder> implements VisitableBuilder<TagReference,TagReferenceBuilder>{

     TagReferenceFluent<?> fluent;
public TagReferenceBuilder(){
    this(new TagReference());
}
public TagReferenceBuilder( TagReferenceFluent<?> fluent ){
    this(fluent, new TagReference());
}
public TagReferenceBuilder( TagReferenceFluent<?> fluent , TagReference instance ){
    this.fluent = fluent; fluent.withAnnotations(instance.getAnnotations()); fluent.withFrom(instance.getFrom()); fluent.withGeneration(instance.getGeneration()); fluent.withImportPolicy(instance.getImportPolicy()); fluent.withName(instance.getName()); fluent.withReference(instance.getReference()); 
}
public TagReferenceBuilder( TagReference instance ){
    this.fluent = this; this.withAnnotations(instance.getAnnotations()); this.withFrom(instance.getFrom()); this.withGeneration(instance.getGeneration()); this.withImportPolicy(instance.getImportPolicy()); this.withName(instance.getName()); this.withReference(instance.getReference()); 
}

public TagReference build(){
    TagReference buildable = new TagReference(fluent.getAnnotations(),fluent.getFrom(),fluent.getGeneration(),fluent.getImportPolicy(),fluent.getName(),fluent.isReference());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
TagReferenceBuilder that = (TagReferenceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
