/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluent;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamedAuthInfoBuilder
extends NamedAuthInfoFluentImpl<NamedAuthInfoBuilder>
implements VisitableBuilder<NamedAuthInfo, NamedAuthInfoBuilder> {
    NamedAuthInfoFluent<?> fluent;

    public NamedAuthInfoBuilder() {
        this(new NamedAuthInfo());
    }

    public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent) {
        this(fluent, new NamedAuthInfo());
    }

    public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent, NamedAuthInfo instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withUser(instance.getUser());
    }

    public NamedAuthInfoBuilder(NamedAuthInfo instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withUser(instance.getUser());
    }

    @Override
    public NamedAuthInfo build() {
        NamedAuthInfo buildable = new NamedAuthInfo(this.fluent.getName(), this.fluent.getUser());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedAuthInfoBuilder that = (NamedAuthInfoBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

