/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeploymentConfigSpecBuilder
extends DeploymentConfigSpecFluentImpl<DeploymentConfigSpecBuilder>
implements VisitableBuilder<DeploymentConfigSpec, DeploymentConfigSpecBuilder> {
    DeploymentConfigSpecFluent<?> fluent;

    public DeploymentConfigSpecBuilder() {
        this(new DeploymentConfigSpec());
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent) {
        this(fluent, new DeploymentConfigSpec());
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent, DeploymentConfigSpec instance) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTemplate(instance.getTemplate());
        fluent.withTest(instance.getTest());
        fluent.withTriggers(instance.getTriggers());
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpec instance) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.withTest(instance.getTest());
        this.withTriggers(instance.getTriggers());
    }

    @Override
    public DeploymentConfigSpec build() {
        DeploymentConfigSpec buildable = new DeploymentConfigSpec(this.fluent.getReplicas(), this.fluent.getSelector(), this.fluent.getStrategy(), this.fluent.getTemplate(), this.fluent.isTest(), this.fluent.getTriggers());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigSpecBuilder that = (DeploymentConfigSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

