/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.NamedClusterRole;
import io.fabric8.openshift.api.model.NamedClusterRoleFluent;
import io.fabric8.openshift.api.model.NamedClusterRoleFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamedClusterRoleBuilder
extends NamedClusterRoleFluentImpl<NamedClusterRoleBuilder>
implements VisitableBuilder<NamedClusterRole, NamedClusterRoleBuilder> {
    NamedClusterRoleFluent<?> fluent;

    public NamedClusterRoleBuilder() {
        this(new NamedClusterRole());
    }

    public NamedClusterRoleBuilder(NamedClusterRoleFluent<?> fluent) {
        this(fluent, new NamedClusterRole());
    }

    public NamedClusterRoleBuilder(NamedClusterRoleFluent<?> fluent, NamedClusterRole instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withRole(instance.getRole());
    }

    public NamedClusterRoleBuilder(NamedClusterRole instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withRole(instance.getRole());
    }

    @Override
    public NamedClusterRole build() {
        NamedClusterRole buildable = new NamedClusterRole(this.fluent.getName(), this.fluent.getRole());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedClusterRoleBuilder that = (NamedClusterRoleBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

