package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface AuthInfoFluent<A extends AuthInfoFluent<A>> extends Fluent<A>{


    public String getAs();
    public A withAs(String as);
    public String getClientCertificate();
    public A withClientCertificate(String clientCertificate);
    public String getClientCertificateData();
    public A withClientCertificateData(String clientCertificateData);
    public String getClientKey();
    public A withClientKey(String clientKey);
    public String getClientKeyData();
    public A withClientKeyData(String clientKeyData);
    public A addToExtensions(NamedExtension... items);
    public A removeFromExtensions(NamedExtension... items);
    public List<NamedExtension> getExtensions();
    public A withExtensions(List<NamedExtension> extensions);
    public A withExtensions(NamedExtension... extensions);
    public AuthInfoFluent.ExtensionsNested<A> addNewExtension();
    public AuthInfoFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item);
    public String getPassword();
    public A withPassword(String password);
    public String getToken();
    public A withToken(String token);
    public String getUsername();
    public A withUsername(String username);

    public interface ExtensionsNested<N> extends Nested<N>,NamedExtensionFluent<AuthInfoFluent.ExtensionsNested<N>>{

        
    public N and();    public N endExtension();
}


}
