package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.String;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;

public interface BuildConfigSpecFluent<A extends BuildConfigSpecFluent<A>> extends Fluent<A>{


    public Long getCompletionDeadlineSeconds();
    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds);
    public BuildOutput getOutput();
    public A withOutput(BuildOutput output);
    public BuildConfigSpecFluent.OutputNested<A> withNewOutput();
    public BuildConfigSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item);
    public BuildConfigSpecFluent.OutputNested<A> editOutput();
    public BuildPostCommitSpec getPostCommit();
    public A withPostCommit(BuildPostCommitSpec postCommit);
    public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommit();
    public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item);
    public BuildConfigSpecFluent.PostCommitNested<A> editPostCommit();
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public BuildConfigSpecFluent.ResourcesNested<A> withNewResources();
    public BuildConfigSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public BuildConfigSpecFluent.ResourcesNested<A> editResources();
    public SourceRevision getRevision();
    public A withRevision(SourceRevision revision);
    public BuildConfigSpecFluent.RevisionNested<A> withNewRevision();
    public BuildConfigSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item);
    public BuildConfigSpecFluent.RevisionNested<A> editRevision();
    public String getRunPolicy();
    public A withRunPolicy(String runPolicy);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public BuildSource getSource();
    public A withSource(BuildSource source);
    public BuildConfigSpecFluent.SourceNested<A> withNewSource();
    public BuildConfigSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item);
    public BuildConfigSpecFluent.SourceNested<A> editSource();
    public BuildStrategy getStrategy();
    public A withStrategy(BuildStrategy strategy);
    public BuildConfigSpecFluent.StrategyNested<A> withNewStrategy();
    public BuildConfigSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item);
    public BuildConfigSpecFluent.StrategyNested<A> editStrategy();
    public A addToTriggers(BuildTriggerPolicy... items);
    public A removeFromTriggers(BuildTriggerPolicy... items);
    public List<BuildTriggerPolicy> getTriggers();
    public A withTriggers(List<BuildTriggerPolicy> triggers);
    public A withTriggers(BuildTriggerPolicy... triggers);
    public BuildConfigSpecFluent.TriggersNested<A> addNewTrigger();
    public BuildConfigSpecFluent.TriggersNested<A> addNewTriggerLike(BuildTriggerPolicy item);

    public interface OutputNested<N> extends Nested<N>,BuildOutputFluent<BuildConfigSpecFluent.OutputNested<N>>{

        
    public N endOutput();    public N and();
}
    public interface PostCommitNested<N> extends Nested<N>,BuildPostCommitSpecFluent<BuildConfigSpecFluent.PostCommitNested<N>>{

        
    public N and();    public N endPostCommit();
}
    public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<BuildConfigSpecFluent.ResourcesNested<N>>{

        
    public N and();    public N endResources();
}
    public interface RevisionNested<N> extends Nested<N>,SourceRevisionFluent<BuildConfigSpecFluent.RevisionNested<N>>{

        
    public N endRevision();    public N and();
}
    public interface SourceNested<N> extends Nested<N>,BuildSourceFluent<BuildConfigSpecFluent.SourceNested<N>>{

        
    public N and();    public N endSource();
}
    public interface StrategyNested<N> extends Nested<N>,BuildStrategyFluent<BuildConfigSpecFluent.StrategyNested<N>>{

        
    public N endStrategy();    public N and();
}
    public interface TriggersNested<N> extends Nested<N>,BuildTriggerPolicyFluent<BuildConfigSpecFluent.TriggersNested<N>>{

        
    public N endTrigger();    public N and();
}


}
