package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class DecBuilder extends DecFluentImpl<DecBuilder> implements VisitableBuilder<Dec,DecBuilder>{

    DecFluent<?> fluent;
    Boolean validationEnabled;

    public DecBuilder(){
            this(true);
    }
    public DecBuilder(Boolean validationEnabled){
            this(new Dec(), validationEnabled);
    }
    public DecBuilder(DecFluent<?> fluent){
            this(fluent, true);
    }
    public DecBuilder(DecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Dec(), validationEnabled);
    }
    public DecBuilder(DecFluent<?> fluent,Dec instance){
            this(fluent, instance, true);
    }
    public DecBuilder(DecFluent<?> fluent,Dec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public DecBuilder(Dec instance){
            this(instance,true);
    }
    public DecBuilder(Dec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public Dec build(){
            Dec buildable = new Dec();
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DecBuilder that = (DecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
