package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class NamedRoleBuilder extends NamedRoleFluentImpl<NamedRoleBuilder> implements VisitableBuilder<NamedRole,NamedRoleBuilder>{

    NamedRoleFluent<?> fluent;
    Boolean validationEnabled;

    public NamedRoleBuilder(){
            this(true);
    }
    public NamedRoleBuilder(Boolean validationEnabled){
            this(new NamedRole(), validationEnabled);
    }
    public NamedRoleBuilder(NamedRoleFluent<?> fluent){
            this(fluent, true);
    }
    public NamedRoleBuilder(NamedRoleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NamedRole(), validationEnabled);
    }
    public NamedRoleBuilder(NamedRoleFluent<?> fluent,NamedRole instance){
            this(fluent, instance, true);
    }
    public NamedRoleBuilder(NamedRoleFluent<?> fluent,NamedRole instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withRole(instance.getRole()); 
            this.validationEnabled = validationEnabled; 
    }
    public NamedRoleBuilder(NamedRole instance){
            this(instance,true);
    }
    public NamedRoleBuilder(NamedRole instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withRole(instance.getRole()); 
            this.validationEnabled = validationEnabled; 
    }

    public NamedRole build(){
            NamedRole buildable = new NamedRole(fluent.getName(),fluent.getRole());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedRoleBuilder that = (NamedRoleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
