package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.ClusterPolicyBindingList;
import io.fabric8.openshift.api.model.ClusterPolicyList;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetList;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityList;
import io.fabric8.openshift.api.model.ImageList;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.extensions.JobList;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.PolicyBindingList;
import io.fabric8.openshift.api.model.PolicyList;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.RoleList;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.kubernetes.api.model.extensions.Scale;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserList;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Boolean;
import java.lang.Long;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.BuildConfigListFluent;
import io.fabric8.openshift.api.model.BuildConfigListBuilder;
import io.fabric8.openshift.api.model.BuildListFluent;
import io.fabric8.openshift.api.model.BuildListBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyFluent;
import io.fabric8.openshift.api.model.ClusterPolicyBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyBindingFluent;
import io.fabric8.openshift.api.model.ClusterPolicyBindingBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyBindingListFluent;
import io.fabric8.openshift.api.model.ClusterPolicyBindingListBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyListFluent;
import io.fabric8.openshift.api.model.ClusterPolicyListBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluent;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBindingListFluent;
import io.fabric8.openshift.api.model.ClusterRoleBindingListBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetListBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigListFluent;
import io.fabric8.openshift.api.model.DeploymentConfigListBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentListFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentListBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackBuilder;
import io.fabric8.openshift.api.model.GroupFluent;
import io.fabric8.openshift.api.model.GroupBuilder;
import io.fabric8.openshift.api.model.GroupListFluent;
import io.fabric8.openshift.api.model.GroupListBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerListFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerListBuilder;
import io.fabric8.openshift.api.model.IdentityFluent;
import io.fabric8.openshift.api.model.IdentityBuilder;
import io.fabric8.openshift.api.model.IdentityListFluent;
import io.fabric8.openshift.api.model.IdentityListBuilder;
import io.fabric8.openshift.api.model.ImageListFluent;
import io.fabric8.openshift.api.model.ImageListBuilder;
import io.fabric8.openshift.api.model.ImageStreamListFluent;
import io.fabric8.openshift.api.model.ImageStreamListBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressListFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressListBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobFluent;
import io.fabric8.kubernetes.api.model.extensions.JobBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobListFluent;
import io.fabric8.kubernetes.api.model.extensions.JobListBuilder;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewFluent;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluent;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenListFluent;
import io.fabric8.openshift.api.model.OAuthAccessTokenListBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenListFluent;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenListBuilder;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationListFluent;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationListBuilder;
import io.fabric8.openshift.api.model.OAuthClientListFluent;
import io.fabric8.openshift.api.model.OAuthClientListBuilder;
import io.fabric8.openshift.api.model.PolicyFluent;
import io.fabric8.openshift.api.model.PolicyBuilder;
import io.fabric8.openshift.api.model.PolicyBindingFluent;
import io.fabric8.openshift.api.model.PolicyBindingBuilder;
import io.fabric8.openshift.api.model.PolicyBindingListFluent;
import io.fabric8.openshift.api.model.PolicyBindingListBuilder;
import io.fabric8.openshift.api.model.PolicyListFluent;
import io.fabric8.openshift.api.model.PolicyListBuilder;
import io.fabric8.openshift.api.model.ProjectFluent;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.ProjectListFluent;
import io.fabric8.openshift.api.model.ProjectListBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetListFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetListBuilder;
import io.fabric8.openshift.api.model.RoleFluent;
import io.fabric8.openshift.api.model.RoleBuilder;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.openshift.api.model.RoleBindingListFluent;
import io.fabric8.openshift.api.model.RoleBindingListBuilder;
import io.fabric8.openshift.api.model.RoleListFluent;
import io.fabric8.openshift.api.model.RoleListBuilder;
import io.fabric8.openshift.api.model.RouteListFluent;
import io.fabric8.openshift.api.model.RouteListBuilder;
import io.fabric8.kubernetes.api.model.extensions.ScaleFluent;
import io.fabric8.kubernetes.api.model.extensions.ScaleBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewFluent;
import io.fabric8.openshift.api.model.SubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponseFluent;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponseBuilder;
import io.fabric8.openshift.api.model.TagEventFluent;
import io.fabric8.openshift.api.model.TagEventBuilder;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateListFluent;
import io.fabric8.openshift.api.model.TemplateListBuilder;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluent;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceBuilder;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceListFluent;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceListBuilder;
import io.fabric8.openshift.api.model.UserFluent;
import io.fabric8.openshift.api.model.UserBuilder;
import io.fabric8.openshift.api.model.UserListFluent;
import io.fabric8.openshift.api.model.UserListBuilder;

public interface KubeSchemaFluent<A extends KubeSchemaFluent<A>> extends Fluent<A>{


    public BaseKubernetesList getBaseKubernetesList();
    public A withBaseKubernetesList(BaseKubernetesList baseKubernetesList);
    public KubeSchemaFluent.BaseKubernetesListNested<A> withNewBaseKubernetesList();
    public KubeSchemaFluent.BaseKubernetesListNested<A> withNewBaseKubernetesListLike(BaseKubernetesList item);
    public KubeSchemaFluent.BaseKubernetesListNested<A> editBaseKubernetesList();
    public Binding getBinding();
    public A withBinding(Binding binding);
    public KubeSchemaFluent.BindingNested<A> withNewBinding();
    public KubeSchemaFluent.BindingNested<A> withNewBindingLike(Binding item);
    public KubeSchemaFluent.BindingNested<A> editBinding();
    public BuildConfigList getBuildConfigList();
    public A withBuildConfigList(BuildConfigList buildConfigList);
    public KubeSchemaFluent.BuildConfigListNested<A> withNewBuildConfigList();
    public KubeSchemaFluent.BuildConfigListNested<A> withNewBuildConfigListLike(BuildConfigList item);
    public KubeSchemaFluent.BuildConfigListNested<A> editBuildConfigList();
    public BuildList getBuildList();
    public A withBuildList(BuildList buildList);
    public KubeSchemaFluent.BuildListNested<A> withNewBuildList();
    public KubeSchemaFluent.BuildListNested<A> withNewBuildListLike(BuildList item);
    public KubeSchemaFluent.BuildListNested<A> editBuildList();
    public BuildRequest getBuildRequest();
    public A withBuildRequest(BuildRequest buildRequest);
    public KubeSchemaFluent.BuildRequestNested<A> withNewBuildRequest();
    public KubeSchemaFluent.BuildRequestNested<A> withNewBuildRequestLike(BuildRequest item);
    public KubeSchemaFluent.BuildRequestNested<A> editBuildRequest();
    public ClusterPolicy getClusterPolicy();
    public A withClusterPolicy(ClusterPolicy clusterPolicy);
    public KubeSchemaFluent.ClusterPolicyNested<A> withNewClusterPolicy();
    public KubeSchemaFluent.ClusterPolicyNested<A> withNewClusterPolicyLike(ClusterPolicy item);
    public KubeSchemaFluent.ClusterPolicyNested<A> editClusterPolicy();
    public ClusterPolicyBinding getClusterPolicyBinding();
    public A withClusterPolicyBinding(ClusterPolicyBinding clusterPolicyBinding);
    public KubeSchemaFluent.ClusterPolicyBindingNested<A> withNewClusterPolicyBinding();
    public KubeSchemaFluent.ClusterPolicyBindingNested<A> withNewClusterPolicyBindingLike(ClusterPolicyBinding item);
    public KubeSchemaFluent.ClusterPolicyBindingNested<A> editClusterPolicyBinding();
    public ClusterPolicyBindingList getClusterPolicyBindingList();
    public A withClusterPolicyBindingList(ClusterPolicyBindingList clusterPolicyBindingList);
    public KubeSchemaFluent.ClusterPolicyBindingListNested<A> withNewClusterPolicyBindingList();
    public KubeSchemaFluent.ClusterPolicyBindingListNested<A> withNewClusterPolicyBindingListLike(ClusterPolicyBindingList item);
    public KubeSchemaFluent.ClusterPolicyBindingListNested<A> editClusterPolicyBindingList();
    public ClusterPolicyList getClusterPolicyList();
    public A withClusterPolicyList(ClusterPolicyList clusterPolicyList);
    public KubeSchemaFluent.ClusterPolicyListNested<A> withNewClusterPolicyList();
    public KubeSchemaFluent.ClusterPolicyListNested<A> withNewClusterPolicyListLike(ClusterPolicyList item);
    public KubeSchemaFluent.ClusterPolicyListNested<A> editClusterPolicyList();
    public ClusterRoleBinding getClusterRoleBinding();
    public A withClusterRoleBinding(ClusterRoleBinding clusterRoleBinding);
    public KubeSchemaFluent.ClusterRoleBindingNested<A> withNewClusterRoleBinding();
    public KubeSchemaFluent.ClusterRoleBindingNested<A> withNewClusterRoleBindingLike(ClusterRoleBinding item);
    public KubeSchemaFluent.ClusterRoleBindingNested<A> editClusterRoleBinding();
    public ClusterRoleBindingList getClusterRoleBindingList();
    public A withClusterRoleBindingList(ClusterRoleBindingList clusterRoleBindingList);
    public KubeSchemaFluent.ClusterRoleBindingListNested<A> withNewClusterRoleBindingList();
    public KubeSchemaFluent.ClusterRoleBindingListNested<A> withNewClusterRoleBindingListLike(ClusterRoleBindingList item);
    public KubeSchemaFluent.ClusterRoleBindingListNested<A> editClusterRoleBindingList();
    public ComponentStatusList getComponentStatusList();
    public A withComponentStatusList(ComponentStatusList componentStatusList);
    public KubeSchemaFluent.ComponentStatusListNested<A> withNewComponentStatusList();
    public KubeSchemaFluent.ComponentStatusListNested<A> withNewComponentStatusListLike(ComponentStatusList item);
    public KubeSchemaFluent.ComponentStatusListNested<A> editComponentStatusList();
    public Config getConfig();
    public A withConfig(Config config);
    public KubeSchemaFluent.ConfigNested<A> withNewConfig();
    public KubeSchemaFluent.ConfigNested<A> withNewConfigLike(Config item);
    public KubeSchemaFluent.ConfigNested<A> editConfig();
    public ConfigMap getConfigMap();
    public A withConfigMap(ConfigMap configMap);
    public KubeSchemaFluent.ConfigMapNested<A> withNewConfigMap();
    public KubeSchemaFluent.ConfigMapNested<A> withNewConfigMapLike(ConfigMap item);
    public KubeSchemaFluent.ConfigMapNested<A> editConfigMap();
    public ConfigMapList getConfigMapList();
    public A withConfigMapList(ConfigMapList configMapList);
    public KubeSchemaFluent.ConfigMapListNested<A> withNewConfigMapList();
    public KubeSchemaFluent.ConfigMapListNested<A> withNewConfigMapListLike(ConfigMapList item);
    public KubeSchemaFluent.ConfigMapListNested<A> editConfigMapList();
    public ContainerStatus getContainerStatus();
    public A withContainerStatus(ContainerStatus containerStatus);
    public KubeSchemaFluent.ContainerStatusNested<A> withNewContainerStatus();
    public KubeSchemaFluent.ContainerStatusNested<A> withNewContainerStatusLike(ContainerStatus item);
    public KubeSchemaFluent.ContainerStatusNested<A> editContainerStatus();
    public DaemonSet getDaemonSet();
    public A withDaemonSet(DaemonSet daemonSet);
    public KubeSchemaFluent.DaemonSetNested<A> withNewDaemonSet();
    public KubeSchemaFluent.DaemonSetNested<A> withNewDaemonSetLike(DaemonSet item);
    public KubeSchemaFluent.DaemonSetNested<A> editDaemonSet();
    public DaemonSetList getDaemonSetList();
    public A withDaemonSetList(DaemonSetList daemonSetList);
    public KubeSchemaFluent.DaemonSetListNested<A> withNewDaemonSetList();
    public KubeSchemaFluent.DaemonSetListNested<A> withNewDaemonSetListLike(DaemonSetList item);
    public KubeSchemaFluent.DaemonSetListNested<A> editDaemonSetList();
    public DeleteOptions getDeleteOptions();
    public A withDeleteOptions(DeleteOptions deleteOptions);
    public KubeSchemaFluent.DeleteOptionsNested<A> withNewDeleteOptions();
    public KubeSchemaFluent.DeleteOptionsNested<A> withNewDeleteOptionsLike(DeleteOptions item);
    public KubeSchemaFluent.DeleteOptionsNested<A> editDeleteOptions();
    public Deployment getDeployment();
    public A withDeployment(Deployment deployment);
    public KubeSchemaFluent.DeploymentNested<A> withNewDeployment();
    public KubeSchemaFluent.DeploymentNested<A> withNewDeploymentLike(Deployment item);
    public KubeSchemaFluent.DeploymentNested<A> editDeployment();
    public DeploymentConfigList getDeploymentConfigList();
    public A withDeploymentConfigList(DeploymentConfigList deploymentConfigList);
    public KubeSchemaFluent.DeploymentConfigListNested<A> withNewDeploymentConfigList();
    public KubeSchemaFluent.DeploymentConfigListNested<A> withNewDeploymentConfigListLike(DeploymentConfigList item);
    public KubeSchemaFluent.DeploymentConfigListNested<A> editDeploymentConfigList();
    public DeploymentList getDeploymentList();
    public A withDeploymentList(DeploymentList deploymentList);
    public KubeSchemaFluent.DeploymentListNested<A> withNewDeploymentList();
    public KubeSchemaFluent.DeploymentListNested<A> withNewDeploymentListLike(DeploymentList item);
    public KubeSchemaFluent.DeploymentListNested<A> editDeploymentList();
    public DeploymentRollback getDeploymentRollback();
    public A withDeploymentRollback(DeploymentRollback deploymentRollback);
    public KubeSchemaFluent.DeploymentRollbackNested<A> withNewDeploymentRollback();
    public KubeSchemaFluent.DeploymentRollbackNested<A> withNewDeploymentRollbackLike(DeploymentRollback item);
    public KubeSchemaFluent.DeploymentRollbackNested<A> editDeploymentRollback();
    public Endpoints getEndpoints();
    public A withEndpoints(Endpoints endpoints);
    public KubeSchemaFluent.EndpointsNested<A> withNewEndpoints();
    public KubeSchemaFluent.EndpointsNested<A> withNewEndpointsLike(Endpoints item);
    public KubeSchemaFluent.EndpointsNested<A> editEndpoints();
    public EndpointsList getEndpointsList();
    public A withEndpointsList(EndpointsList endpointsList);
    public KubeSchemaFluent.EndpointsListNested<A> withNewEndpointsList();
    public KubeSchemaFluent.EndpointsListNested<A> withNewEndpointsListLike(EndpointsList item);
    public KubeSchemaFluent.EndpointsListNested<A> editEndpointsList();
    public EnvVar getEnvVar();
    public A withEnvVar(EnvVar envVar);
    public KubeSchemaFluent.EnvVarNested<A> withNewEnvVar();
    public KubeSchemaFluent.EnvVarNested<A> withNewEnvVarLike(EnvVar item);
    public KubeSchemaFluent.EnvVarNested<A> editEnvVar();
    public EventList getEventList();
    public A withEventList(EventList eventList);
    public KubeSchemaFluent.EventListNested<A> withNewEventList();
    public KubeSchemaFluent.EventListNested<A> withNewEventListLike(EventList item);
    public KubeSchemaFluent.EventListNested<A> editEventList();
    public Group getGroup();
    public A withGroup(Group group);
    public KubeSchemaFluent.GroupNested<A> withNewGroup();
    public KubeSchemaFluent.GroupNested<A> withNewGroupLike(Group item);
    public KubeSchemaFluent.GroupNested<A> editGroup();
    public GroupList getGroupList();
    public A withGroupList(GroupList groupList);
    public KubeSchemaFluent.GroupListNested<A> withNewGroupList();
    public KubeSchemaFluent.GroupListNested<A> withNewGroupListLike(GroupList item);
    public KubeSchemaFluent.GroupListNested<A> editGroupList();
    public HorizontalPodAutoscaler getHorizontalPodAutoscaler();
    public A withHorizontalPodAutoscaler(HorizontalPodAutoscaler horizontalPodAutoscaler);
    public KubeSchemaFluent.HorizontalPodAutoscalerNested<A> withNewHorizontalPodAutoscaler();
    public KubeSchemaFluent.HorizontalPodAutoscalerNested<A> withNewHorizontalPodAutoscalerLike(HorizontalPodAutoscaler item);
    public KubeSchemaFluent.HorizontalPodAutoscalerNested<A> editHorizontalPodAutoscaler();
    public HorizontalPodAutoscalerList getHorizontalPodAutoscalerList();
    public A withHorizontalPodAutoscalerList(HorizontalPodAutoscalerList horizontalPodAutoscalerList);
    public KubeSchemaFluent.HorizontalPodAutoscalerListNested<A> withNewHorizontalPodAutoscalerList();
    public KubeSchemaFluent.HorizontalPodAutoscalerListNested<A> withNewHorizontalPodAutoscalerListLike(HorizontalPodAutoscalerList item);
    public KubeSchemaFluent.HorizontalPodAutoscalerListNested<A> editHorizontalPodAutoscalerList();
    public Identity getIdentity();
    public A withIdentity(Identity identity);
    public KubeSchemaFluent.IdentityNested<A> withNewIdentity();
    public KubeSchemaFluent.IdentityNested<A> withNewIdentityLike(Identity item);
    public KubeSchemaFluent.IdentityNested<A> editIdentity();
    public IdentityList getIdentityList();
    public A withIdentityList(IdentityList identityList);
    public KubeSchemaFluent.IdentityListNested<A> withNewIdentityList();
    public KubeSchemaFluent.IdentityListNested<A> withNewIdentityListLike(IdentityList item);
    public KubeSchemaFluent.IdentityListNested<A> editIdentityList();
    public ImageList getImageList();
    public A withImageList(ImageList imageList);
    public KubeSchemaFluent.ImageListNested<A> withNewImageList();
    public KubeSchemaFluent.ImageListNested<A> withNewImageListLike(ImageList item);
    public KubeSchemaFluent.ImageListNested<A> editImageList();
    public ImageStreamList getImageStreamList();
    public A withImageStreamList(ImageStreamList imageStreamList);
    public KubeSchemaFluent.ImageStreamListNested<A> withNewImageStreamList();
    public KubeSchemaFluent.ImageStreamListNested<A> withNewImageStreamListLike(ImageStreamList item);
    public KubeSchemaFluent.ImageStreamListNested<A> editImageStreamList();
    public Ingress getIngress();
    public A withIngress(Ingress ingress);
    public KubeSchemaFluent.IngressNested<A> withNewIngress();
    public KubeSchemaFluent.IngressNested<A> withNewIngressLike(Ingress item);
    public KubeSchemaFluent.IngressNested<A> editIngress();
    public IngressList getIngressList();
    public A withIngressList(IngressList ingressList);
    public KubeSchemaFluent.IngressListNested<A> withNewIngressList();
    public KubeSchemaFluent.IngressListNested<A> withNewIngressListLike(IngressList item);
    public KubeSchemaFluent.IngressListNested<A> editIngressList();
    public Job getJob();
    public A withJob(Job job);
    public KubeSchemaFluent.JobNested<A> withNewJob();
    public KubeSchemaFluent.JobNested<A> withNewJobLike(Job item);
    public KubeSchemaFluent.JobNested<A> editJob();
    public JobList getJobList();
    public A withJobList(JobList jobList);
    public KubeSchemaFluent.JobListNested<A> withNewJobList();
    public KubeSchemaFluent.JobListNested<A> withNewJobListLike(JobList item);
    public KubeSchemaFluent.JobListNested<A> editJobList();
    public LimitRangeList getLimitRangeList();
    public A withLimitRangeList(LimitRangeList limitRangeList);
    public KubeSchemaFluent.LimitRangeListNested<A> withNewLimitRangeList();
    public KubeSchemaFluent.LimitRangeListNested<A> withNewLimitRangeListLike(LimitRangeList item);
    public KubeSchemaFluent.LimitRangeListNested<A> editLimitRangeList();
    public ListMeta getListMeta();
    public A withListMeta(ListMeta listMeta);
    public KubeSchemaFluent.ListMetaNested<A> withNewListMeta();
    public KubeSchemaFluent.ListMetaNested<A> withNewListMetaLike(ListMeta item);
    public KubeSchemaFluent.ListMetaNested<A> editListMeta();
    public A withNewListMeta(String resourceVersion,String selfLink);
    public LocalSubjectAccessReview getLocalSubjectAccessReview();
    public A withLocalSubjectAccessReview(LocalSubjectAccessReview localSubjectAccessReview);
    public KubeSchemaFluent.LocalSubjectAccessReviewNested<A> withNewLocalSubjectAccessReview();
    public KubeSchemaFluent.LocalSubjectAccessReviewNested<A> withNewLocalSubjectAccessReviewLike(LocalSubjectAccessReview item);
    public KubeSchemaFluent.LocalSubjectAccessReviewNested<A> editLocalSubjectAccessReview();
    public Namespace getNamespace();
    public A withNamespace(Namespace namespace);
    public KubeSchemaFluent.NamespaceNested<A> withNewNamespace();
    public KubeSchemaFluent.NamespaceNested<A> withNewNamespaceLike(Namespace item);
    public KubeSchemaFluent.NamespaceNested<A> editNamespace();
    public NamespaceList getNamespaceList();
    public A withNamespaceList(NamespaceList namespaceList);
    public KubeSchemaFluent.NamespaceListNested<A> withNewNamespaceList();
    public KubeSchemaFluent.NamespaceListNested<A> withNewNamespaceListLike(NamespaceList item);
    public KubeSchemaFluent.NamespaceListNested<A> editNamespaceList();
    public Node getNode();
    public A withNode(Node node);
    public KubeSchemaFluent.NodeNested<A> withNewNode();
    public KubeSchemaFluent.NodeNested<A> withNewNodeLike(Node item);
    public KubeSchemaFluent.NodeNested<A> editNode();
    public NodeList getNodeList();
    public A withNodeList(NodeList nodeList);
    public KubeSchemaFluent.NodeListNested<A> withNewNodeList();
    public KubeSchemaFluent.NodeListNested<A> withNewNodeListLike(NodeList item);
    public KubeSchemaFluent.NodeListNested<A> editNodeList();
    public OAuthAccessToken getOAuthAccessToken();
    public A withOAuthAccessToken(OAuthAccessToken oAuthAccessToken);
    public KubeSchemaFluent.OAuthAccessTokenNested<A> withNewOAuthAccessToken();
    public KubeSchemaFluent.OAuthAccessTokenNested<A> withNewOAuthAccessTokenLike(OAuthAccessToken item);
    public KubeSchemaFluent.OAuthAccessTokenNested<A> editOAuthAccessToken();
    public OAuthAccessTokenList getOAuthAccessTokenList();
    public A withOAuthAccessTokenList(OAuthAccessTokenList oAuthAccessTokenList);
    public KubeSchemaFluent.OAuthAccessTokenListNested<A> withNewOAuthAccessTokenList();
    public KubeSchemaFluent.OAuthAccessTokenListNested<A> withNewOAuthAccessTokenListLike(OAuthAccessTokenList item);
    public KubeSchemaFluent.OAuthAccessTokenListNested<A> editOAuthAccessTokenList();
    public OAuthAuthorizeToken getOAuthAuthorizeToken();
    public A withOAuthAuthorizeToken(OAuthAuthorizeToken oAuthAuthorizeToken);
    public KubeSchemaFluent.OAuthAuthorizeTokenNested<A> withNewOAuthAuthorizeToken();
    public KubeSchemaFluent.OAuthAuthorizeTokenNested<A> withNewOAuthAuthorizeTokenLike(OAuthAuthorizeToken item);
    public KubeSchemaFluent.OAuthAuthorizeTokenNested<A> editOAuthAuthorizeToken();
    public OAuthAuthorizeTokenList getOAuthAuthorizeTokenList();
    public A withOAuthAuthorizeTokenList(OAuthAuthorizeTokenList oAuthAuthorizeTokenList);
    public KubeSchemaFluent.OAuthAuthorizeTokenListNested<A> withNewOAuthAuthorizeTokenList();
    public KubeSchemaFluent.OAuthAuthorizeTokenListNested<A> withNewOAuthAuthorizeTokenListLike(OAuthAuthorizeTokenList item);
    public KubeSchemaFluent.OAuthAuthorizeTokenListNested<A> editOAuthAuthorizeTokenList();
    public OAuthClient getOAuthClient();
    public A withOAuthClient(OAuthClient oAuthClient);
    public KubeSchemaFluent.OAuthClientNested<A> withNewOAuthClient();
    public KubeSchemaFluent.OAuthClientNested<A> withNewOAuthClientLike(OAuthClient item);
    public KubeSchemaFluent.OAuthClientNested<A> editOAuthClient();
    public OAuthClientAuthorization getOAuthClientAuthorization();
    public A withOAuthClientAuthorization(OAuthClientAuthorization oAuthClientAuthorization);
    public KubeSchemaFluent.OAuthClientAuthorizationNested<A> withNewOAuthClientAuthorization();
    public KubeSchemaFluent.OAuthClientAuthorizationNested<A> withNewOAuthClientAuthorizationLike(OAuthClientAuthorization item);
    public KubeSchemaFluent.OAuthClientAuthorizationNested<A> editOAuthClientAuthorization();
    public OAuthClientAuthorizationList getOAuthClientAuthorizationList();
    public A withOAuthClientAuthorizationList(OAuthClientAuthorizationList oAuthClientAuthorizationList);
    public KubeSchemaFluent.OAuthClientAuthorizationListNested<A> withNewOAuthClientAuthorizationList();
    public KubeSchemaFluent.OAuthClientAuthorizationListNested<A> withNewOAuthClientAuthorizationListLike(OAuthClientAuthorizationList item);
    public KubeSchemaFluent.OAuthClientAuthorizationListNested<A> editOAuthClientAuthorizationList();
    public OAuthClientList getOAuthClientList();
    public A withOAuthClientList(OAuthClientList oAuthClientList);
    public KubeSchemaFluent.OAuthClientListNested<A> withNewOAuthClientList();
    public KubeSchemaFluent.OAuthClientListNested<A> withNewOAuthClientListLike(OAuthClientList item);
    public KubeSchemaFluent.OAuthClientListNested<A> editOAuthClientList();
    public ObjectMeta getObjectMeta();
    public A withObjectMeta(ObjectMeta objectMeta);
    public KubeSchemaFluent.ObjectMetaNested<A> withNewObjectMeta();
    public KubeSchemaFluent.ObjectMetaNested<A> withNewObjectMetaLike(ObjectMeta item);
    public KubeSchemaFluent.ObjectMetaNested<A> editObjectMeta();
    public Patch getPatch();
    public A withPatch(Patch patch);
    public KubeSchemaFluent.PatchNested<A> withNewPatch();
    public KubeSchemaFluent.PatchNested<A> withNewPatchLike(Patch item);
    public KubeSchemaFluent.PatchNested<A> editPatch();
    public PersistentVolume getPersistentVolume();
    public A withPersistentVolume(PersistentVolume persistentVolume);
    public KubeSchemaFluent.PersistentVolumeNested<A> withNewPersistentVolume();
    public KubeSchemaFluent.PersistentVolumeNested<A> withNewPersistentVolumeLike(PersistentVolume item);
    public KubeSchemaFluent.PersistentVolumeNested<A> editPersistentVolume();
    public PersistentVolumeClaim getPersistentVolumeClaim();
    public A withPersistentVolumeClaim(PersistentVolumeClaim persistentVolumeClaim);
    public KubeSchemaFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim();
    public KubeSchemaFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaim item);
    public KubeSchemaFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim();
    public PersistentVolumeClaimList getPersistentVolumeClaimList();
    public A withPersistentVolumeClaimList(PersistentVolumeClaimList persistentVolumeClaimList);
    public KubeSchemaFluent.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimList();
    public KubeSchemaFluent.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimListLike(PersistentVolumeClaimList item);
    public KubeSchemaFluent.PersistentVolumeClaimListNested<A> editPersistentVolumeClaimList();
    public PersistentVolumeList getPersistentVolumeList();
    public A withPersistentVolumeList(PersistentVolumeList persistentVolumeList);
    public KubeSchemaFluent.PersistentVolumeListNested<A> withNewPersistentVolumeList();
    public KubeSchemaFluent.PersistentVolumeListNested<A> withNewPersistentVolumeListLike(PersistentVolumeList item);
    public KubeSchemaFluent.PersistentVolumeListNested<A> editPersistentVolumeList();
    public PodList getPodList();
    public A withPodList(PodList podList);
    public KubeSchemaFluent.PodListNested<A> withNewPodList();
    public KubeSchemaFluent.PodListNested<A> withNewPodListLike(PodList item);
    public KubeSchemaFluent.PodListNested<A> editPodList();
    public PodTemplateList getPodTemplateList();
    public A withPodTemplateList(PodTemplateList podTemplateList);
    public KubeSchemaFluent.PodTemplateListNested<A> withNewPodTemplateList();
    public KubeSchemaFluent.PodTemplateListNested<A> withNewPodTemplateListLike(PodTemplateList item);
    public KubeSchemaFluent.PodTemplateListNested<A> editPodTemplateList();
    public Policy getPolicy();
    public A withPolicy(Policy policy);
    public KubeSchemaFluent.PolicyNested<A> withNewPolicy();
    public KubeSchemaFluent.PolicyNested<A> withNewPolicyLike(Policy item);
    public KubeSchemaFluent.PolicyNested<A> editPolicy();
    public PolicyBinding getPolicyBinding();
    public A withPolicyBinding(PolicyBinding policyBinding);
    public KubeSchemaFluent.PolicyBindingNested<A> withNewPolicyBinding();
    public KubeSchemaFluent.PolicyBindingNested<A> withNewPolicyBindingLike(PolicyBinding item);
    public KubeSchemaFluent.PolicyBindingNested<A> editPolicyBinding();
    public PolicyBindingList getPolicyBindingList();
    public A withPolicyBindingList(PolicyBindingList policyBindingList);
    public KubeSchemaFluent.PolicyBindingListNested<A> withNewPolicyBindingList();
    public KubeSchemaFluent.PolicyBindingListNested<A> withNewPolicyBindingListLike(PolicyBindingList item);
    public KubeSchemaFluent.PolicyBindingListNested<A> editPolicyBindingList();
    public PolicyList getPolicyList();
    public A withPolicyList(PolicyList policyList);
    public KubeSchemaFluent.PolicyListNested<A> withNewPolicyList();
    public KubeSchemaFluent.PolicyListNested<A> withNewPolicyListLike(PolicyList item);
    public KubeSchemaFluent.PolicyListNested<A> editPolicyList();
    public Project getProject();
    public A withProject(Project project);
    public KubeSchemaFluent.ProjectNested<A> withNewProject();
    public KubeSchemaFluent.ProjectNested<A> withNewProjectLike(Project item);
    public KubeSchemaFluent.ProjectNested<A> editProject();
    public ProjectList getProjectList();
    public A withProjectList(ProjectList projectList);
    public KubeSchemaFluent.ProjectListNested<A> withNewProjectList();
    public KubeSchemaFluent.ProjectListNested<A> withNewProjectListLike(ProjectList item);
    public KubeSchemaFluent.ProjectListNested<A> editProjectList();
    public ProjectRequest getProjectRequest();
    public A withProjectRequest(ProjectRequest projectRequest);
    public KubeSchemaFluent.ProjectRequestNested<A> withNewProjectRequest();
    public KubeSchemaFluent.ProjectRequestNested<A> withNewProjectRequestLike(ProjectRequest item);
    public KubeSchemaFluent.ProjectRequestNested<A> editProjectRequest();
    public Quantity getQuantity();
    public A withQuantity(Quantity quantity);
    public KubeSchemaFluent.QuantityNested<A> withNewQuantity();
    public KubeSchemaFluent.QuantityNested<A> withNewQuantityLike(Quantity item);
    public KubeSchemaFluent.QuantityNested<A> editQuantity();
    public A withNewQuantity(String amount);
    public A withNewQuantity(String amount,String format);
    public ReplicaSet getReplicaSet();
    public A withReplicaSet(ReplicaSet replicaSet);
    public KubeSchemaFluent.ReplicaSetNested<A> withNewReplicaSet();
    public KubeSchemaFluent.ReplicaSetNested<A> withNewReplicaSetLike(ReplicaSet item);
    public KubeSchemaFluent.ReplicaSetNested<A> editReplicaSet();
    public ReplicaSetList getReplicaSetList();
    public A withReplicaSetList(ReplicaSetList replicaSetList);
    public KubeSchemaFluent.ReplicaSetListNested<A> withNewReplicaSetList();
    public KubeSchemaFluent.ReplicaSetListNested<A> withNewReplicaSetListLike(ReplicaSetList item);
    public KubeSchemaFluent.ReplicaSetListNested<A> editReplicaSetList();
    public ReplicationControllerList getReplicationControllerList();
    public A withReplicationControllerList(ReplicationControllerList replicationControllerList);
    public KubeSchemaFluent.ReplicationControllerListNested<A> withNewReplicationControllerList();
    public KubeSchemaFluent.ReplicationControllerListNested<A> withNewReplicationControllerListLike(ReplicationControllerList item);
    public KubeSchemaFluent.ReplicationControllerListNested<A> editReplicationControllerList();
    public ResourceQuota getResourceQuota();
    public A withResourceQuota(ResourceQuota resourceQuota);
    public KubeSchemaFluent.ResourceQuotaNested<A> withNewResourceQuota();
    public KubeSchemaFluent.ResourceQuotaNested<A> withNewResourceQuotaLike(ResourceQuota item);
    public KubeSchemaFluent.ResourceQuotaNested<A> editResourceQuota();
    public ResourceQuotaList getResourceQuotaList();
    public A withResourceQuotaList(ResourceQuotaList resourceQuotaList);
    public KubeSchemaFluent.ResourceQuotaListNested<A> withNewResourceQuotaList();
    public KubeSchemaFluent.ResourceQuotaListNested<A> withNewResourceQuotaListLike(ResourceQuotaList item);
    public KubeSchemaFluent.ResourceQuotaListNested<A> editResourceQuotaList();
    public Role getRole();
    public A withRole(Role role);
    public KubeSchemaFluent.RoleNested<A> withNewRole();
    public KubeSchemaFluent.RoleNested<A> withNewRoleLike(Role item);
    public KubeSchemaFluent.RoleNested<A> editRole();
    public RoleBinding getRoleBinding();
    public A withRoleBinding(RoleBinding roleBinding);
    public KubeSchemaFluent.RoleBindingNested<A> withNewRoleBinding();
    public KubeSchemaFluent.RoleBindingNested<A> withNewRoleBindingLike(RoleBinding item);
    public KubeSchemaFluent.RoleBindingNested<A> editRoleBinding();
    public RoleBindingList getRoleBindingList();
    public A withRoleBindingList(RoleBindingList roleBindingList);
    public KubeSchemaFluent.RoleBindingListNested<A> withNewRoleBindingList();
    public KubeSchemaFluent.RoleBindingListNested<A> withNewRoleBindingListLike(RoleBindingList item);
    public KubeSchemaFluent.RoleBindingListNested<A> editRoleBindingList();
    public RoleList getRoleList();
    public A withRoleList(RoleList roleList);
    public KubeSchemaFluent.RoleListNested<A> withNewRoleList();
    public KubeSchemaFluent.RoleListNested<A> withNewRoleListLike(RoleList item);
    public KubeSchemaFluent.RoleListNested<A> editRoleList();
    public RootPaths getRootPaths();
    public A withRootPaths(RootPaths rootPaths);
    public KubeSchemaFluent.RootPathsNested<A> withNewRootPaths();
    public KubeSchemaFluent.RootPathsNested<A> withNewRootPathsLike(RootPaths item);
    public KubeSchemaFluent.RootPathsNested<A> editRootPaths();
    public RouteList getRouteList();
    public A withRouteList(RouteList routeList);
    public KubeSchemaFluent.RouteListNested<A> withNewRouteList();
    public KubeSchemaFluent.RouteListNested<A> withNewRouteListLike(RouteList item);
    public KubeSchemaFluent.RouteListNested<A> editRouteList();
    public Scale getScale();
    public A withScale(Scale scale);
    public KubeSchemaFluent.ScaleNested<A> withNewScale();
    public KubeSchemaFluent.ScaleNested<A> withNewScaleLike(Scale item);
    public KubeSchemaFluent.ScaleNested<A> editScale();
    public Secret getSecret();
    public A withSecret(Secret secret);
    public KubeSchemaFluent.SecretNested<A> withNewSecret();
    public KubeSchemaFluent.SecretNested<A> withNewSecretLike(Secret item);
    public KubeSchemaFluent.SecretNested<A> editSecret();
    public SecretList getSecretList();
    public A withSecretList(SecretList secretList);
    public KubeSchemaFluent.SecretListNested<A> withNewSecretList();
    public KubeSchemaFluent.SecretListNested<A> withNewSecretListLike(SecretList item);
    public KubeSchemaFluent.SecretListNested<A> editSecretList();
    public SecurityContextConstraints getSecurityContextConstraints();
    public A withSecurityContextConstraints(SecurityContextConstraints securityContextConstraints);
    public KubeSchemaFluent.SecurityContextConstraintsNested<A> withNewSecurityContextConstraints();
    public KubeSchemaFluent.SecurityContextConstraintsNested<A> withNewSecurityContextConstraintsLike(SecurityContextConstraints item);
    public KubeSchemaFluent.SecurityContextConstraintsNested<A> editSecurityContextConstraints();
    public SecurityContextConstraintsList getSecurityContextConstraintsList();
    public A withSecurityContextConstraintsList(SecurityContextConstraintsList securityContextConstraintsList);
    public KubeSchemaFluent.SecurityContextConstraintsListNested<A> withNewSecurityContextConstraintsList();
    public KubeSchemaFluent.SecurityContextConstraintsListNested<A> withNewSecurityContextConstraintsListLike(SecurityContextConstraintsList item);
    public KubeSchemaFluent.SecurityContextConstraintsListNested<A> editSecurityContextConstraintsList();
    public ServiceAccount getServiceAccount();
    public A withServiceAccount(ServiceAccount serviceAccount);
    public KubeSchemaFluent.ServiceAccountNested<A> withNewServiceAccount();
    public KubeSchemaFluent.ServiceAccountNested<A> withNewServiceAccountLike(ServiceAccount item);
    public KubeSchemaFluent.ServiceAccountNested<A> editServiceAccount();
    public ServiceAccountList getServiceAccountList();
    public A withServiceAccountList(ServiceAccountList serviceAccountList);
    public KubeSchemaFluent.ServiceAccountListNested<A> withNewServiceAccountList();
    public KubeSchemaFluent.ServiceAccountListNested<A> withNewServiceAccountListLike(ServiceAccountList item);
    public KubeSchemaFluent.ServiceAccountListNested<A> editServiceAccountList();
    public ServiceList getServiceList();
    public A withServiceList(ServiceList serviceList);
    public KubeSchemaFluent.ServiceListNested<A> withNewServiceList();
    public KubeSchemaFluent.ServiceListNested<A> withNewServiceListLike(ServiceList item);
    public KubeSchemaFluent.ServiceListNested<A> editServiceList();
    public Status getStatus();
    public A withStatus(Status status);
    public KubeSchemaFluent.StatusNested<A> withNewStatus();
    public KubeSchemaFluent.StatusNested<A> withNewStatusLike(Status item);
    public KubeSchemaFluent.StatusNested<A> editStatus();
    public SubjectAccessReview getSubjectAccessReview();
    public A withSubjectAccessReview(SubjectAccessReview subjectAccessReview);
    public KubeSchemaFluent.SubjectAccessReviewNested<A> withNewSubjectAccessReview();
    public KubeSchemaFluent.SubjectAccessReviewNested<A> withNewSubjectAccessReviewLike(SubjectAccessReview item);
    public KubeSchemaFluent.SubjectAccessReviewNested<A> editSubjectAccessReview();
    public SubjectAccessReviewResponse getSubjectAccessReviewResponse();
    public A withSubjectAccessReviewResponse(SubjectAccessReviewResponse subjectAccessReviewResponse);
    public KubeSchemaFluent.SubjectAccessReviewResponseNested<A> withNewSubjectAccessReviewResponse();
    public KubeSchemaFluent.SubjectAccessReviewResponseNested<A> withNewSubjectAccessReviewResponseLike(SubjectAccessReviewResponse item);
    public KubeSchemaFluent.SubjectAccessReviewResponseNested<A> editSubjectAccessReviewResponse();
    public A withNewSubjectAccessReviewResponse(Boolean allowed,String apiVersion,String kind,String namespace,String reason);
    public TagEvent getTagEvent();
    public A withTagEvent(TagEvent tagEvent);
    public KubeSchemaFluent.TagEventNested<A> withNewTagEvent();
    public KubeSchemaFluent.TagEventNested<A> withNewTagEventLike(TagEvent item);
    public KubeSchemaFluent.TagEventNested<A> editTagEvent();
    public A withNewTagEvent(String created,String dockerImageReference,Long generation,String image);
    public Template getTemplate();
    public A withTemplate(Template template);
    public KubeSchemaFluent.TemplateNested<A> withNewTemplate();
    public KubeSchemaFluent.TemplateNested<A> withNewTemplateLike(Template item);
    public KubeSchemaFluent.TemplateNested<A> editTemplate();
    public TemplateList getTemplateList();
    public A withTemplateList(TemplateList templateList);
    public KubeSchemaFluent.TemplateListNested<A> withNewTemplateList();
    public KubeSchemaFluent.TemplateListNested<A> withNewTemplateListLike(TemplateList item);
    public KubeSchemaFluent.TemplateListNested<A> editTemplateList();
    public ThirdPartyResource getThirdPartyResource();
    public A withThirdPartyResource(ThirdPartyResource thirdPartyResource);
    public KubeSchemaFluent.ThirdPartyResourceNested<A> withNewThirdPartyResource();
    public KubeSchemaFluent.ThirdPartyResourceNested<A> withNewThirdPartyResourceLike(ThirdPartyResource item);
    public KubeSchemaFluent.ThirdPartyResourceNested<A> editThirdPartyResource();
    public ThirdPartyResourceList getThirdPartyResourceList();
    public A withThirdPartyResourceList(ThirdPartyResourceList thirdPartyResourceList);
    public KubeSchemaFluent.ThirdPartyResourceListNested<A> withNewThirdPartyResourceList();
    public KubeSchemaFluent.ThirdPartyResourceListNested<A> withNewThirdPartyResourceListLike(ThirdPartyResourceList item);
    public KubeSchemaFluent.ThirdPartyResourceListNested<A> editThirdPartyResourceList();
    public User getUser();
    public A withUser(User user);
    public KubeSchemaFluent.UserNested<A> withNewUser();
    public KubeSchemaFluent.UserNested<A> withNewUserLike(User item);
    public KubeSchemaFluent.UserNested<A> editUser();
    public UserList getUserList();
    public A withUserList(UserList userList);
    public KubeSchemaFluent.UserListNested<A> withNewUserList();
    public KubeSchemaFluent.UserListNested<A> withNewUserListLike(UserList item);
    public KubeSchemaFluent.UserListNested<A> editUserList();
    public WatchEvent getWatchEvent();
    public A withWatchEvent(WatchEvent watchEvent);
    public KubeSchemaFluent.WatchEventNested<A> withNewWatchEvent();
    public KubeSchemaFluent.WatchEventNested<A> withNewWatchEventLike(WatchEvent item);
    public KubeSchemaFluent.WatchEventNested<A> editWatchEvent();

    public interface BaseKubernetesListNested<N> extends Nested<N>,BaseKubernetesListFluent<KubeSchemaFluent.BaseKubernetesListNested<N>>{

        
    public N and();    public N endBaseKubernetesList();
}
    public interface BindingNested<N> extends Nested<N>,BindingFluent<KubeSchemaFluent.BindingNested<N>>{

        
    public N and();    public N endBinding();
}
    public interface BuildConfigListNested<N> extends Nested<N>,BuildConfigListFluent<KubeSchemaFluent.BuildConfigListNested<N>>{

        
    public N endBuildConfigList();    public N and();
}
    public interface BuildListNested<N> extends Nested<N>,BuildListFluent<KubeSchemaFluent.BuildListNested<N>>{

        
    public N endBuildList();    public N and();
}
    public interface BuildRequestNested<N> extends Nested<N>,BuildRequestFluent<KubeSchemaFluent.BuildRequestNested<N>>{

        
    public N and();    public N endBuildRequest();
}
    public interface ClusterPolicyNested<N> extends Nested<N>,ClusterPolicyFluent<KubeSchemaFluent.ClusterPolicyNested<N>>{

        
    public N endClusterPolicy();    public N and();
}
    public interface ClusterPolicyBindingNested<N> extends Nested<N>,ClusterPolicyBindingFluent<KubeSchemaFluent.ClusterPolicyBindingNested<N>>{

        
    public N endClusterPolicyBinding();    public N and();
}
    public interface ClusterPolicyBindingListNested<N> extends Nested<N>,ClusterPolicyBindingListFluent<KubeSchemaFluent.ClusterPolicyBindingListNested<N>>{

        
    public N endClusterPolicyBindingList();    public N and();
}
    public interface ClusterPolicyListNested<N> extends Nested<N>,ClusterPolicyListFluent<KubeSchemaFluent.ClusterPolicyListNested<N>>{

        
    public N and();    public N endClusterPolicyList();
}
    public interface ClusterRoleBindingNested<N> extends Nested<N>,ClusterRoleBindingFluent<KubeSchemaFluent.ClusterRoleBindingNested<N>>{

        
    public N endClusterRoleBinding();    public N and();
}
    public interface ClusterRoleBindingListNested<N> extends Nested<N>,ClusterRoleBindingListFluent<KubeSchemaFluent.ClusterRoleBindingListNested<N>>{

        
    public N endClusterRoleBindingList();    public N and();
}
    public interface ComponentStatusListNested<N> extends Nested<N>,ComponentStatusListFluent<KubeSchemaFluent.ComponentStatusListNested<N>>{

        
    public N endComponentStatusList();    public N and();
}
    public interface ConfigNested<N> extends Nested<N>,ConfigFluent<KubeSchemaFluent.ConfigNested<N>>{

        
    public N endConfig();    public N and();
}
    public interface ConfigMapNested<N> extends Nested<N>,ConfigMapFluent<KubeSchemaFluent.ConfigMapNested<N>>{

        
    public N and();    public N endConfigMap();
}
    public interface ConfigMapListNested<N> extends Nested<N>,ConfigMapListFluent<KubeSchemaFluent.ConfigMapListNested<N>>{

        
    public N endConfigMapList();    public N and();
}
    public interface ContainerStatusNested<N> extends Nested<N>,ContainerStatusFluent<KubeSchemaFluent.ContainerStatusNested<N>>{

        
    public N and();    public N endContainerStatus();
}
    public interface DaemonSetNested<N> extends Nested<N>,DaemonSetFluent<KubeSchemaFluent.DaemonSetNested<N>>{

        
    public N and();    public N endDaemonSet();
}
    public interface DaemonSetListNested<N> extends Nested<N>,DaemonSetListFluent<KubeSchemaFluent.DaemonSetListNested<N>>{

        
    public N endDaemonSetList();    public N and();
}
    public interface DeleteOptionsNested<N> extends Nested<N>,DeleteOptionsFluent<KubeSchemaFluent.DeleteOptionsNested<N>>{

        
    public N endDeleteOptions();    public N and();
}
    public interface DeploymentNested<N> extends Nested<N>,DeploymentFluent<KubeSchemaFluent.DeploymentNested<N>>{

        
    public N and();    public N endDeployment();
}
    public interface DeploymentConfigListNested<N> extends Nested<N>,DeploymentConfigListFluent<KubeSchemaFluent.DeploymentConfigListNested<N>>{

        
    public N endDeploymentConfigList();    public N and();
}
    public interface DeploymentListNested<N> extends Nested<N>,DeploymentListFluent<KubeSchemaFluent.DeploymentListNested<N>>{

        
    public N and();    public N endDeploymentList();
}
    public interface DeploymentRollbackNested<N> extends Nested<N>,DeploymentRollbackFluent<KubeSchemaFluent.DeploymentRollbackNested<N>>{

        
    public N endDeploymentRollback();    public N and();
}
    public interface EndpointsNested<N> extends Nested<N>,EndpointsFluent<KubeSchemaFluent.EndpointsNested<N>>{

        
    public N and();    public N endEndpoints();
}
    public interface EndpointsListNested<N> extends Nested<N>,EndpointsListFluent<KubeSchemaFluent.EndpointsListNested<N>>{

        
    public N and();    public N endEndpointsList();
}
    public interface EnvVarNested<N> extends Nested<N>,EnvVarFluent<KubeSchemaFluent.EnvVarNested<N>>{

        
    public N and();    public N endEnvVar();
}
    public interface EventListNested<N> extends Nested<N>,EventListFluent<KubeSchemaFluent.EventListNested<N>>{

        
    public N and();    public N endEventList();
}
    public interface GroupNested<N> extends Nested<N>,GroupFluent<KubeSchemaFluent.GroupNested<N>>{

        
    public N and();    public N endGroup();
}
    public interface GroupListNested<N> extends Nested<N>,GroupListFluent<KubeSchemaFluent.GroupListNested<N>>{

        
    public N endGroupList();    public N and();
}
    public interface HorizontalPodAutoscalerNested<N> extends Nested<N>,HorizontalPodAutoscalerFluent<KubeSchemaFluent.HorizontalPodAutoscalerNested<N>>{

        
    public N endHorizontalPodAutoscaler();    public N and();
}
    public interface HorizontalPodAutoscalerListNested<N> extends Nested<N>,HorizontalPodAutoscalerListFluent<KubeSchemaFluent.HorizontalPodAutoscalerListNested<N>>{

        
    public N and();    public N endHorizontalPodAutoscalerList();
}
    public interface IdentityNested<N> extends Nested<N>,IdentityFluent<KubeSchemaFluent.IdentityNested<N>>{

        
    public N and();    public N endIdentity();
}
    public interface IdentityListNested<N> extends Nested<N>,IdentityListFluent<KubeSchemaFluent.IdentityListNested<N>>{

        
    public N endIdentityList();    public N and();
}
    public interface ImageListNested<N> extends Nested<N>,ImageListFluent<KubeSchemaFluent.ImageListNested<N>>{

        
    public N and();    public N endImageList();
}
    public interface ImageStreamListNested<N> extends Nested<N>,ImageStreamListFluent<KubeSchemaFluent.ImageStreamListNested<N>>{

        
    public N and();    public N endImageStreamList();
}
    public interface IngressNested<N> extends Nested<N>,IngressFluent<KubeSchemaFluent.IngressNested<N>>{

        
    public N endIngress();    public N and();
}
    public interface IngressListNested<N> extends Nested<N>,IngressListFluent<KubeSchemaFluent.IngressListNested<N>>{

        
    public N and();    public N endIngressList();
}
    public interface JobNested<N> extends Nested<N>,JobFluent<KubeSchemaFluent.JobNested<N>>{

        
    public N endJob();    public N and();
}
    public interface JobListNested<N> extends Nested<N>,JobListFluent<KubeSchemaFluent.JobListNested<N>>{

        
    public N and();    public N endJobList();
}
    public interface LimitRangeListNested<N> extends Nested<N>,LimitRangeListFluent<KubeSchemaFluent.LimitRangeListNested<N>>{

        
    public N and();    public N endLimitRangeList();
}
    public interface ListMetaNested<N> extends Nested<N>,ListMetaFluent<KubeSchemaFluent.ListMetaNested<N>>{

        
    public N endListMeta();    public N and();
}
    public interface LocalSubjectAccessReviewNested<N> extends Nested<N>,LocalSubjectAccessReviewFluent<KubeSchemaFluent.LocalSubjectAccessReviewNested<N>>{

        
    public N and();    public N endLocalSubjectAccessReview();
}
    public interface NamespaceNested<N> extends Nested<N>,NamespaceFluent<KubeSchemaFluent.NamespaceNested<N>>{

        
    public N endNamespace();    public N and();
}
    public interface NamespaceListNested<N> extends Nested<N>,NamespaceListFluent<KubeSchemaFluent.NamespaceListNested<N>>{

        
    public N endNamespaceList();    public N and();
}
    public interface NodeNested<N> extends Nested<N>,NodeFluent<KubeSchemaFluent.NodeNested<N>>{

        
    public N endNode();    public N and();
}
    public interface NodeListNested<N> extends Nested<N>,NodeListFluent<KubeSchemaFluent.NodeListNested<N>>{

        
    public N endNodeList();    public N and();
}
    public interface OAuthAccessTokenNested<N> extends Nested<N>,OAuthAccessTokenFluent<KubeSchemaFluent.OAuthAccessTokenNested<N>>{

        
    public N endOAuthAccessToken();    public N and();
}
    public interface OAuthAccessTokenListNested<N> extends Nested<N>,OAuthAccessTokenListFluent<KubeSchemaFluent.OAuthAccessTokenListNested<N>>{

        
    public N and();    public N endOAuthAccessTokenList();
}
    public interface OAuthAuthorizeTokenNested<N> extends Nested<N>,OAuthAuthorizeTokenFluent<KubeSchemaFluent.OAuthAuthorizeTokenNested<N>>{

        
    public N and();    public N endOAuthAuthorizeToken();
}
    public interface OAuthAuthorizeTokenListNested<N> extends Nested<N>,OAuthAuthorizeTokenListFluent<KubeSchemaFluent.OAuthAuthorizeTokenListNested<N>>{

        
    public N and();    public N endOAuthAuthorizeTokenList();
}
    public interface OAuthClientNested<N> extends Nested<N>,OAuthClientFluent<KubeSchemaFluent.OAuthClientNested<N>>{

        
    public N and();    public N endOAuthClient();
}
    public interface OAuthClientAuthorizationNested<N> extends Nested<N>,OAuthClientAuthorizationFluent<KubeSchemaFluent.OAuthClientAuthorizationNested<N>>{

        
    public N endOAuthClientAuthorization();    public N and();
}
    public interface OAuthClientAuthorizationListNested<N> extends Nested<N>,OAuthClientAuthorizationListFluent<KubeSchemaFluent.OAuthClientAuthorizationListNested<N>>{

        
    public N and();    public N endOAuthClientAuthorizationList();
}
    public interface OAuthClientListNested<N> extends Nested<N>,OAuthClientListFluent<KubeSchemaFluent.OAuthClientListNested<N>>{

        
    public N and();    public N endOAuthClientList();
}
    public interface ObjectMetaNested<N> extends Nested<N>,ObjectMetaFluent<KubeSchemaFluent.ObjectMetaNested<N>>{

        
    public N endObjectMeta();    public N and();
}
    public interface PatchNested<N> extends Nested<N>,PatchFluent<KubeSchemaFluent.PatchNested<N>>{

        
    public N endPatch();    public N and();
}
    public interface PersistentVolumeNested<N> extends Nested<N>,PersistentVolumeFluent<KubeSchemaFluent.PersistentVolumeNested<N>>{

        
    public N endPersistentVolume();    public N and();
}
    public interface PersistentVolumeClaimNested<N> extends Nested<N>,PersistentVolumeClaimFluent<KubeSchemaFluent.PersistentVolumeClaimNested<N>>{

        
    public N endPersistentVolumeClaim();    public N and();
}
    public interface PersistentVolumeClaimListNested<N> extends Nested<N>,PersistentVolumeClaimListFluent<KubeSchemaFluent.PersistentVolumeClaimListNested<N>>{

        
    public N and();    public N endPersistentVolumeClaimList();
}
    public interface PersistentVolumeListNested<N> extends Nested<N>,PersistentVolumeListFluent<KubeSchemaFluent.PersistentVolumeListNested<N>>{

        
    public N and();    public N endPersistentVolumeList();
}
    public interface PodListNested<N> extends Nested<N>,PodListFluent<KubeSchemaFluent.PodListNested<N>>{

        
    public N endPodList();    public N and();
}
    public interface PodTemplateListNested<N> extends Nested<N>,PodTemplateListFluent<KubeSchemaFluent.PodTemplateListNested<N>>{

        
    public N and();    public N endPodTemplateList();
}
    public interface PolicyNested<N> extends Nested<N>,PolicyFluent<KubeSchemaFluent.PolicyNested<N>>{

        
    public N endPolicy();    public N and();
}
    public interface PolicyBindingNested<N> extends Nested<N>,PolicyBindingFluent<KubeSchemaFluent.PolicyBindingNested<N>>{

        
    public N endPolicyBinding();    public N and();
}
    public interface PolicyBindingListNested<N> extends Nested<N>,PolicyBindingListFluent<KubeSchemaFluent.PolicyBindingListNested<N>>{

        
    public N endPolicyBindingList();    public N and();
}
    public interface PolicyListNested<N> extends Nested<N>,PolicyListFluent<KubeSchemaFluent.PolicyListNested<N>>{

        
    public N and();    public N endPolicyList();
}
    public interface ProjectNested<N> extends Nested<N>,ProjectFluent<KubeSchemaFluent.ProjectNested<N>>{

        
    public N endProject();    public N and();
}
    public interface ProjectListNested<N> extends Nested<N>,ProjectListFluent<KubeSchemaFluent.ProjectListNested<N>>{

        
    public N endProjectList();    public N and();
}
    public interface ProjectRequestNested<N> extends Nested<N>,ProjectRequestFluent<KubeSchemaFluent.ProjectRequestNested<N>>{

        
    public N endProjectRequest();    public N and();
}
    public interface QuantityNested<N> extends Nested<N>,QuantityFluent<KubeSchemaFluent.QuantityNested<N>>{

        
    public N and();    public N endQuantity();
}
    public interface ReplicaSetNested<N> extends Nested<N>,ReplicaSetFluent<KubeSchemaFluent.ReplicaSetNested<N>>{

        
    public N endReplicaSet();    public N and();
}
    public interface ReplicaSetListNested<N> extends Nested<N>,ReplicaSetListFluent<KubeSchemaFluent.ReplicaSetListNested<N>>{

        
    public N endReplicaSetList();    public N and();
}
    public interface ReplicationControllerListNested<N> extends Nested<N>,ReplicationControllerListFluent<KubeSchemaFluent.ReplicationControllerListNested<N>>{

        
    public N endReplicationControllerList();    public N and();
}
    public interface ResourceQuotaNested<N> extends Nested<N>,ResourceQuotaFluent<KubeSchemaFluent.ResourceQuotaNested<N>>{

        
    public N and();    public N endResourceQuota();
}
    public interface ResourceQuotaListNested<N> extends Nested<N>,ResourceQuotaListFluent<KubeSchemaFluent.ResourceQuotaListNested<N>>{

        
    public N and();    public N endResourceQuotaList();
}
    public interface RoleNested<N> extends Nested<N>,RoleFluent<KubeSchemaFluent.RoleNested<N>>{

        
    public N endRole();    public N and();
}
    public interface RoleBindingNested<N> extends Nested<N>,RoleBindingFluent<KubeSchemaFluent.RoleBindingNested<N>>{

        
    public N endRoleBinding();    public N and();
}
    public interface RoleBindingListNested<N> extends Nested<N>,RoleBindingListFluent<KubeSchemaFluent.RoleBindingListNested<N>>{

        
    public N and();    public N endRoleBindingList();
}
    public interface RoleListNested<N> extends Nested<N>,RoleListFluent<KubeSchemaFluent.RoleListNested<N>>{

        
    public N endRoleList();    public N and();
}
    public interface RootPathsNested<N> extends Nested<N>,RootPathsFluent<KubeSchemaFluent.RootPathsNested<N>>{

        
    public N endRootPaths();    public N and();
}
    public interface RouteListNested<N> extends Nested<N>,RouteListFluent<KubeSchemaFluent.RouteListNested<N>>{

        
    public N endRouteList();    public N and();
}
    public interface ScaleNested<N> extends Nested<N>,ScaleFluent<KubeSchemaFluent.ScaleNested<N>>{

        
    public N endScale();    public N and();
}
    public interface SecretNested<N> extends Nested<N>,SecretFluent<KubeSchemaFluent.SecretNested<N>>{

        
    public N and();    public N endSecret();
}
    public interface SecretListNested<N> extends Nested<N>,SecretListFluent<KubeSchemaFluent.SecretListNested<N>>{

        
    public N and();    public N endSecretList();
}
    public interface SecurityContextConstraintsNested<N> extends Nested<N>,SecurityContextConstraintsFluent<KubeSchemaFluent.SecurityContextConstraintsNested<N>>{

        
    public N endSecurityContextConstraints();    public N and();
}
    public interface SecurityContextConstraintsListNested<N> extends Nested<N>,SecurityContextConstraintsListFluent<KubeSchemaFluent.SecurityContextConstraintsListNested<N>>{

        
    public N endSecurityContextConstraintsList();    public N and();
}
    public interface ServiceAccountNested<N> extends Nested<N>,ServiceAccountFluent<KubeSchemaFluent.ServiceAccountNested<N>>{

        
    public N and();    public N endServiceAccount();
}
    public interface ServiceAccountListNested<N> extends Nested<N>,ServiceAccountListFluent<KubeSchemaFluent.ServiceAccountListNested<N>>{

        
    public N and();    public N endServiceAccountList();
}
    public interface ServiceListNested<N> extends Nested<N>,ServiceListFluent<KubeSchemaFluent.ServiceListNested<N>>{

        
    public N endServiceList();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,StatusFluent<KubeSchemaFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}
    public interface SubjectAccessReviewNested<N> extends Nested<N>,SubjectAccessReviewFluent<KubeSchemaFluent.SubjectAccessReviewNested<N>>{

        
    public N and();    public N endSubjectAccessReview();
}
    public interface SubjectAccessReviewResponseNested<N> extends Nested<N>,SubjectAccessReviewResponseFluent<KubeSchemaFluent.SubjectAccessReviewResponseNested<N>>{

        
    public N and();    public N endSubjectAccessReviewResponse();
}
    public interface TagEventNested<N> extends Nested<N>,TagEventFluent<KubeSchemaFluent.TagEventNested<N>>{

        
    public N endTagEvent();    public N and();
}
    public interface TemplateNested<N> extends Nested<N>,TemplateFluent<KubeSchemaFluent.TemplateNested<N>>{

        
    public N endTemplate();    public N and();
}
    public interface TemplateListNested<N> extends Nested<N>,TemplateListFluent<KubeSchemaFluent.TemplateListNested<N>>{

        
    public N endTemplateList();    public N and();
}
    public interface ThirdPartyResourceNested<N> extends Nested<N>,ThirdPartyResourceFluent<KubeSchemaFluent.ThirdPartyResourceNested<N>>{

        
    public N endThirdPartyResource();    public N and();
}
    public interface ThirdPartyResourceListNested<N> extends Nested<N>,ThirdPartyResourceListFluent<KubeSchemaFluent.ThirdPartyResourceListNested<N>>{

        
    public N and();    public N endThirdPartyResourceList();
}
    public interface UserNested<N> extends Nested<N>,UserFluent<KubeSchemaFluent.UserNested<N>>{

        
    public N and();    public N endUser();
}
    public interface UserListNested<N> extends Nested<N>,UserListFluent<KubeSchemaFluent.UserListNested<N>>{

        
    public N endUserList();    public N and();
}
    public interface WatchEventNested<N> extends Nested<N>,WatchEventFluent<KubeSchemaFluent.WatchEventNested<N>>{

        
    public N endWatchEvent();    public N and();
}


}
