package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface LimitRangeSpecFluent<A extends LimitRangeSpecFluent<A>> extends Fluent<A>{


    public A addToLimits(LimitRangeItem... items);
    public A removeFromLimits(LimitRangeItem... items);
    public List<LimitRangeItem> getLimits();
    public A withLimits(List<LimitRangeItem> limits);
    public A withLimits(LimitRangeItem... limits);
    public LimitRangeSpecFluent.LimitsNested<A> addNewLimit();
    public LimitRangeSpecFluent.LimitsNested<A> addNewLimitLike(LimitRangeItem item);

    public interface LimitsNested<N> extends Nested<N>,LimitRangeItemFluent<LimitRangeSpecFluent.LimitsNested<N>>{

        
    public N and();    public N endLimit();
}


}
