package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class ObjectMetaBuilder extends ObjectMetaFluentImpl<ObjectMetaBuilder> implements VisitableBuilder<ObjectMeta,ObjectMetaBuilder>{

    ObjectMetaFluent<?> fluent;
    Boolean validationEnabled;

    public ObjectMetaBuilder(){
            this(true);
    }
    public ObjectMetaBuilder(Boolean validationEnabled){
            this(new ObjectMeta(), validationEnabled);
    }
    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent){
            this(fluent, true);
    }
    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ObjectMeta(), validationEnabled);
    }
    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent,ObjectMeta instance){
            this(fluent, instance, true);
    }
    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent,ObjectMeta instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAnnotations(instance.getAnnotations()); 
            fluent.withCreationTimestamp(instance.getCreationTimestamp()); 
            fluent.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds()); 
            fluent.withDeletionTimestamp(instance.getDeletionTimestamp()); 
            fluent.withGenerateName(instance.getGenerateName()); 
            fluent.withGeneration(instance.getGeneration()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withName(instance.getName()); 
            fluent.withNamespace(instance.getNamespace()); 
            fluent.withResourceVersion(instance.getResourceVersion()); 
            fluent.withSelfLink(instance.getSelfLink()); 
            fluent.withUid(instance.getUid()); 
            this.validationEnabled = validationEnabled; 
    }
    public ObjectMetaBuilder(ObjectMeta instance){
            this(instance,true);
    }
    public ObjectMetaBuilder(ObjectMeta instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAnnotations(instance.getAnnotations()); 
            this.withCreationTimestamp(instance.getCreationTimestamp()); 
            this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds()); 
            this.withDeletionTimestamp(instance.getDeletionTimestamp()); 
            this.withGenerateName(instance.getGenerateName()); 
            this.withGeneration(instance.getGeneration()); 
            this.withLabels(instance.getLabels()); 
            this.withName(instance.getName()); 
            this.withNamespace(instance.getNamespace()); 
            this.withResourceVersion(instance.getResourceVersion()); 
            this.withSelfLink(instance.getSelfLink()); 
            this.withUid(instance.getUid()); 
            this.validationEnabled = validationEnabled; 
    }

    public ObjectMeta build(){
            ObjectMeta buildable = new ObjectMeta(fluent.getAnnotations(),fluent.getCreationTimestamp(),fluent.getDeletionGracePeriodSeconds(),fluent.getDeletionTimestamp(),fluent.getGenerateName(),fluent.getGeneration(),fluent.getLabels(),fluent.getName(),fluent.getNamespace(),fluent.getResourceVersion(),fluent.getSelfLink(),fluent.getUid());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ObjectMetaBuilder that = (ObjectMetaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
