package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Map;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class PersistentVolumeSpecFluentImpl<A extends PersistentVolumeSpecFluent<A>> extends BaseFluent<A> implements PersistentVolumeSpecFluent<A>{

    private List<String> accessModes = new ArrayList<String>();
    private VisitableBuilder<? extends AWSElasticBlockStoreVolumeSource,?> awsElasticBlockStore;
    private VisitableBuilder<? extends AzureFileVolumeSource,?> azureFile;
    private Map<String,Quantity> capacity = new LinkedHashMap<String,Quantity>();
    private VisitableBuilder<? extends CephFSVolumeSource,?> cephfs;
    private VisitableBuilder<? extends CinderVolumeSource,?> cinder;
    private VisitableBuilder<? extends ObjectReference,?> claimRef;
    private VisitableBuilder<? extends FCVolumeSource,?> fc;
    private VisitableBuilder<? extends FlexVolumeSource,?> flexVolume;
    private VisitableBuilder<? extends FlockerVolumeSource,?> flocker;
    private VisitableBuilder<? extends GCEPersistentDiskVolumeSource,?> gcePersistentDisk;
    private VisitableBuilder<? extends GlusterfsVolumeSource,?> glusterfs;
    private VisitableBuilder<? extends HostPathVolumeSource,?> hostPath;
    private VisitableBuilder<? extends ISCSIVolumeSource,?> iscsi;
    private VisitableBuilder<? extends NFSVolumeSource,?> nfs;
    private String persistentVolumeReclaimPolicy;
    private VisitableBuilder<? extends RBDVolumeSource,?> rbd;

    public PersistentVolumeSpecFluentImpl(){
    }
    public PersistentVolumeSpecFluentImpl(PersistentVolumeSpec instance){
            this.withAccessModes(instance.getAccessModes()); 
            this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); 
            this.withAzureFile(instance.getAzureFile()); 
            this.withCapacity(instance.getCapacity()); 
            this.withCephfs(instance.getCephfs()); 
            this.withCinder(instance.getCinder()); 
            this.withClaimRef(instance.getClaimRef()); 
            this.withFc(instance.getFc()); 
            this.withFlexVolume(instance.getFlexVolume()); 
            this.withFlocker(instance.getFlocker()); 
            this.withGcePersistentDisk(instance.getGcePersistentDisk()); 
            this.withGlusterfs(instance.getGlusterfs()); 
            this.withHostPath(instance.getHostPath()); 
            this.withIscsi(instance.getIscsi()); 
            this.withNfs(instance.getNfs()); 
            this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy()); 
            this.withRbd(instance.getRbd()); 
    }

    public A addToAccessModes(String... items){
            for (String item : items) {this.accessModes.add(item);} return (A)this;
    }

    public A removeFromAccessModes(String... items){
            for (String item : items) {this.accessModes.remove(item);} return (A)this;
    }

    public List<String> getAccessModes(){
            return this.accessModes;
    }

    public A withAccessModes(List<String> accessModes){
            this.accessModes.clear();
            if (accessModes != null) {for (String item : accessModes){this.addToAccessModes(item);}} return (A) this;
    }

    public A withAccessModes(String... accessModes){
            this.accessModes.clear(); if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
    }

    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore(){
            return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
    }

    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore){
            if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.add(this.awsElasticBlockStore);} return (A) this;
    }

    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore(){
            return new AwsElasticBlockStoreNestedImpl();
    }

    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item){
            return new AwsElasticBlockStoreNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore(){
            return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
    }

    public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID){
            return (A)withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    public AzureFileVolumeSource getAzureFile(){
            return this.azureFile!=null?this.azureFile.build():null;
    }

    public A withAzureFile(AzureFileVolumeSource azureFile){
            if (azureFile!=null){ this.azureFile= new AzureFileVolumeSourceBuilder(azureFile); _visitables.add(this.azureFile);} return (A) this;
    }

    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFile(){
            return new AzureFileNestedImpl();
    }

    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item){
            return new AzureFileNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.AzureFileNested<A> editAzureFile(){
            return withNewAzureFileLike(getAzureFile());
    }

    public A withNewAzureFile(Boolean readOnly,String secretName,String shareName){
            return (A)withAzureFile(new AzureFileVolumeSource(readOnly, secretName, shareName));
    }

    public A addToCapacity(String key,Quantity value){
            if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
    }

    public A addToCapacity(Map<String,Quantity> map){
            if(map != null) { this.capacity.putAll(map);} return (A)this;
    }

    public A removeFromCapacity(String key){
            if(key != null) {this.capacity.remove(key);} return (A)this;
    }

    public A removeFromCapacity(Map<String,Quantity> map){
            if(map != null) { for(Object key : map.keySet()) {this.capacity.remove(key);}} return (A)this;
    }

    public Map<String,Quantity> getCapacity(){
            return this.capacity;
    }

    public A withCapacity(Map<String,Quantity> capacity){
            this.capacity.clear();
            if (capacity != null) {this.capacity.putAll(capacity);} return (A) this;
    }

    public CephFSVolumeSource getCephfs(){
            return this.cephfs!=null?this.cephfs.build():null;
    }

    public A withCephfs(CephFSVolumeSource cephfs){
            if (cephfs!=null){ this.cephfs= new CephFSVolumeSourceBuilder(cephfs); _visitables.add(this.cephfs);} return (A) this;
    }

    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfs(){
            return new CephfsNestedImpl();
    }

    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item){
            return new CephfsNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.CephfsNested<A> editCephfs(){
            return withNewCephfsLike(getCephfs());
    }

    public CinderVolumeSource getCinder(){
            return this.cinder!=null?this.cinder.build():null;
    }

    public A withCinder(CinderVolumeSource cinder){
            if (cinder!=null){ this.cinder= new CinderVolumeSourceBuilder(cinder); _visitables.add(this.cinder);} return (A) this;
    }

    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinder(){
            return new CinderNestedImpl();
    }

    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item){
            return new CinderNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.CinderNested<A> editCinder(){
            return withNewCinderLike(getCinder());
    }

    public A withNewCinder(String fsType,Boolean readOnly,String volumeID){
            return (A)withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }

    public ObjectReference getClaimRef(){
            return this.claimRef!=null?this.claimRef.build():null;
    }

    public A withClaimRef(ObjectReference claimRef){
            if (claimRef!=null){ this.claimRef= new ObjectReferenceBuilder(claimRef); _visitables.add(this.claimRef);} return (A) this;
    }

    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRef(){
            return new ClaimRefNestedImpl();
    }

    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRefLike(ObjectReference item){
            return new ClaimRefNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.ClaimRefNested<A> editClaimRef(){
            return withNewClaimRefLike(getClaimRef());
    }

    public FCVolumeSource getFc(){
            return this.fc!=null?this.fc.build():null;
    }

    public A withFc(FCVolumeSource fc){
            if (fc!=null){ this.fc= new FCVolumeSourceBuilder(fc); _visitables.add(this.fc);} return (A) this;
    }

    public PersistentVolumeSpecFluent.FcNested<A> withNewFc(){
            return new FcNestedImpl();
    }

    public PersistentVolumeSpecFluent.FcNested<A> withNewFcLike(FCVolumeSource item){
            return new FcNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.FcNested<A> editFc(){
            return withNewFcLike(getFc());
    }

    public FlexVolumeSource getFlexVolume(){
            return this.flexVolume!=null?this.flexVolume.build():null;
    }

    public A withFlexVolume(FlexVolumeSource flexVolume){
            if (flexVolume!=null){ this.flexVolume= new FlexVolumeSourceBuilder(flexVolume); _visitables.add(this.flexVolume);} return (A) this;
    }

    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolume(){
            return new FlexVolumeNestedImpl();
    }

    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item){
            return new FlexVolumeNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editFlexVolume(){
            return withNewFlexVolumeLike(getFlexVolume());
    }

    public FlockerVolumeSource getFlocker(){
            return this.flocker!=null?this.flocker.build():null;
    }

    public A withFlocker(FlockerVolumeSource flocker){
            if (flocker!=null){ this.flocker= new FlockerVolumeSourceBuilder(flocker); _visitables.add(this.flocker);} return (A) this;
    }

    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlocker(){
            return new FlockerNestedImpl();
    }

    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item){
            return new FlockerNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.FlockerNested<A> editFlocker(){
            return withNewFlockerLike(getFlocker());
    }

    public A withNewFlocker(String datasetName){
            return (A)withFlocker(new FlockerVolumeSource(datasetName));
    }

    public GCEPersistentDiskVolumeSource getGcePersistentDisk(){
            return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
    }

    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk){
            if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.add(this.gcePersistentDisk);} return (A) this;
    }

    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk(){
            return new GcePersistentDiskNestedImpl();
    }

    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item){
            return new GcePersistentDiskNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editGcePersistentDisk(){
            return withNewGcePersistentDiskLike(getGcePersistentDisk());
    }

    public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly){
            return (A)withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    public GlusterfsVolumeSource getGlusterfs(){
            return this.glusterfs!=null?this.glusterfs.build():null;
    }

    public A withGlusterfs(GlusterfsVolumeSource glusterfs){
            if (glusterfs!=null){ this.glusterfs= new GlusterfsVolumeSourceBuilder(glusterfs); _visitables.add(this.glusterfs);} return (A) this;
    }

    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfs(){
            return new GlusterfsNestedImpl();
    }

    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item){
            return new GlusterfsNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.GlusterfsNested<A> editGlusterfs(){
            return withNewGlusterfsLike(getGlusterfs());
    }

    public A withNewGlusterfs(String endpoints,String path,Boolean readOnly){
            return (A)withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    public HostPathVolumeSource getHostPath(){
            return this.hostPath!=null?this.hostPath.build():null;
    }

    public A withHostPath(HostPathVolumeSource hostPath){
            if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.add(this.hostPath);} return (A) this;
    }

    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPath(){
            return new HostPathNestedImpl();
    }

    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item){
            return new HostPathNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.HostPathNested<A> editHostPath(){
            return withNewHostPathLike(getHostPath());
    }

    public A withNewHostPath(String path){
            return (A)withHostPath(new HostPathVolumeSource(path));
    }

    public ISCSIVolumeSource getIscsi(){
            return this.iscsi!=null?this.iscsi.build():null;
    }

    public A withIscsi(ISCSIVolumeSource iscsi){
            if (iscsi!=null){ this.iscsi= new ISCSIVolumeSourceBuilder(iscsi); _visitables.add(this.iscsi);} return (A) this;
    }

    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsi(){
            return new IscsiNestedImpl();
    }

    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item){
            return new IscsiNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.IscsiNested<A> editIscsi(){
            return withNewIscsiLike(getIscsi());
    }

    public NFSVolumeSource getNfs(){
            return this.nfs!=null?this.nfs.build():null;
    }

    public A withNfs(NFSVolumeSource nfs){
            if (nfs!=null){ this.nfs= new NFSVolumeSourceBuilder(nfs); _visitables.add(this.nfs);} return (A) this;
    }

    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfs(){
            return new NfsNestedImpl();
    }

    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item){
            return new NfsNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.NfsNested<A> editNfs(){
            return withNewNfsLike(getNfs());
    }

    public A withNewNfs(String path,Boolean readOnly,String server){
            return (A)withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    public String getPersistentVolumeReclaimPolicy(){
            return this.persistentVolumeReclaimPolicy;
    }

    public A withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy){
            this.persistentVolumeReclaimPolicy=persistentVolumeReclaimPolicy; return (A) this;
    }

    public RBDVolumeSource getRbd(){
            return this.rbd!=null?this.rbd.build():null;
    }

    public A withRbd(RBDVolumeSource rbd){
            if (rbd!=null){ this.rbd= new RBDVolumeSourceBuilder(rbd); _visitables.add(this.rbd);} return (A) this;
    }

    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbd(){
            return new RbdNestedImpl();
    }

    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item){
            return new RbdNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.RbdNested<A> editRbd(){
            return withNewRbdLike(getRbd());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PersistentVolumeSpecFluentImpl that = (PersistentVolumeSpecFluentImpl) o;
            if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
            if (awsElasticBlockStore != null ? !awsElasticBlockStore.equals(that.awsElasticBlockStore) :that.awsElasticBlockStore != null) return false;
            if (azureFile != null ? !azureFile.equals(that.azureFile) :that.azureFile != null) return false;
            if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
            if (cephfs != null ? !cephfs.equals(that.cephfs) :that.cephfs != null) return false;
            if (cinder != null ? !cinder.equals(that.cinder) :that.cinder != null) return false;
            if (claimRef != null ? !claimRef.equals(that.claimRef) :that.claimRef != null) return false;
            if (fc != null ? !fc.equals(that.fc) :that.fc != null) return false;
            if (flexVolume != null ? !flexVolume.equals(that.flexVolume) :that.flexVolume != null) return false;
            if (flocker != null ? !flocker.equals(that.flocker) :that.flocker != null) return false;
            if (gcePersistentDisk != null ? !gcePersistentDisk.equals(that.gcePersistentDisk) :that.gcePersistentDisk != null) return false;
            if (glusterfs != null ? !glusterfs.equals(that.glusterfs) :that.glusterfs != null) return false;
            if (hostPath != null ? !hostPath.equals(that.hostPath) :that.hostPath != null) return false;
            if (iscsi != null ? !iscsi.equals(that.iscsi) :that.iscsi != null) return false;
            if (nfs != null ? !nfs.equals(that.nfs) :that.nfs != null) return false;
            if (persistentVolumeReclaimPolicy != null ? !persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) :that.persistentVolumeReclaimPolicy != null) return false;
            if (rbd != null ? !rbd.equals(that.rbd) :that.rbd != null) return false;
            return true;
    }


    public class AwsElasticBlockStoreNestedImpl<N> extends AWSElasticBlockStoreVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>> implements PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>,Nested<N>{

            private final AWSElasticBlockStoreVolumeSourceBuilder builder;
    
            AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item){
                    this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
            }
            AwsElasticBlockStoreNestedImpl(){
                    this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
            }
    
    public N endAwsElasticBlockStore(){
            return and();
    }
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withAwsElasticBlockStore(builder.build());
    }

}
    public class AzureFileNestedImpl<N> extends AzureFileVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AzureFileNested<N>> implements PersistentVolumeSpecFluent.AzureFileNested<N>,Nested<N>{

            private final AzureFileVolumeSourceBuilder builder;
    
            AzureFileNestedImpl(AzureFileVolumeSource item){
                    this.builder = new AzureFileVolumeSourceBuilder(this, item);
            }
            AzureFileNestedImpl(){
                    this.builder = new AzureFileVolumeSourceBuilder(this);
            }
    
    public N endAzureFile(){
            return and();
    }
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withAzureFile(builder.build());
    }

}
    public class CephfsNestedImpl<N> extends CephFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CephfsNested<N>> implements PersistentVolumeSpecFluent.CephfsNested<N>,Nested<N>{

            private final CephFSVolumeSourceBuilder builder;
    
            CephfsNestedImpl(){
                    this.builder = new CephFSVolumeSourceBuilder(this);
            }
            CephfsNestedImpl(CephFSVolumeSource item){
                    this.builder = new CephFSVolumeSourceBuilder(this, item);
            }
    
    public N endCephfs(){
            return and();
    }
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withCephfs(builder.build());
    }

}
    public class CinderNestedImpl<N> extends CinderVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CinderNested<N>> implements PersistentVolumeSpecFluent.CinderNested<N>,Nested<N>{

            private final CinderVolumeSourceBuilder builder;
    
            CinderNestedImpl(){
                    this.builder = new CinderVolumeSourceBuilder(this);
            }
            CinderNestedImpl(CinderVolumeSource item){
                    this.builder = new CinderVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withCinder(builder.build());
    }
    public N endCinder(){
            return and();
    }

}
    public class ClaimRefNestedImpl<N> extends ObjectReferenceFluentImpl<PersistentVolumeSpecFluent.ClaimRefNested<N>> implements PersistentVolumeSpecFluent.ClaimRefNested<N>,Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            ClaimRefNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
            ClaimRefNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withClaimRef(builder.build());
    }
    public N endClaimRef(){
            return and();
    }

}
    public class FcNestedImpl<N> extends FCVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FcNested<N>> implements PersistentVolumeSpecFluent.FcNested<N>,Nested<N>{

            private final FCVolumeSourceBuilder builder;
    
            FcNestedImpl(FCVolumeSource item){
                    this.builder = new FCVolumeSourceBuilder(this, item);
            }
            FcNestedImpl(){
                    this.builder = new FCVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFc(builder.build());
    }
    public N endFc(){
            return and();
    }

}
    public class FlexVolumeNestedImpl<N> extends FlexVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlexVolumeNested<N>> implements PersistentVolumeSpecFluent.FlexVolumeNested<N>,Nested<N>{

            private final FlexVolumeSourceBuilder builder;
    
            FlexVolumeNestedImpl(){
                    this.builder = new FlexVolumeSourceBuilder(this);
            }
            FlexVolumeNestedImpl(FlexVolumeSource item){
                    this.builder = new FlexVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFlexVolume(builder.build());
    }
    public N endFlexVolume(){
            return and();
    }

}
    public class FlockerNestedImpl<N> extends FlockerVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlockerNested<N>> implements PersistentVolumeSpecFluent.FlockerNested<N>,Nested<N>{

            private final FlockerVolumeSourceBuilder builder;
    
            FlockerNestedImpl(){
                    this.builder = new FlockerVolumeSourceBuilder(this);
            }
            FlockerNestedImpl(FlockerVolumeSource item){
                    this.builder = new FlockerVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFlocker(builder.build());
    }
    public N endFlocker(){
            return and();
    }

}
    public class GcePersistentDiskNestedImpl<N> extends GCEPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GcePersistentDiskNested<N>> implements PersistentVolumeSpecFluent.GcePersistentDiskNested<N>,Nested<N>{

            private final GCEPersistentDiskVolumeSourceBuilder builder;
    
            GcePersistentDiskNestedImpl(){
                    this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
            }
            GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item){
                    this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
            }
    
    public N endGcePersistentDisk(){
            return and();
    }
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withGcePersistentDisk(builder.build());
    }

}
    public class GlusterfsNestedImpl<N> extends GlusterfsVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GlusterfsNested<N>> implements PersistentVolumeSpecFluent.GlusterfsNested<N>,Nested<N>{

            private final GlusterfsVolumeSourceBuilder builder;
    
            GlusterfsNestedImpl(){
                    this.builder = new GlusterfsVolumeSourceBuilder(this);
            }
            GlusterfsNestedImpl(GlusterfsVolumeSource item){
                    this.builder = new GlusterfsVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withGlusterfs(builder.build());
    }
    public N endGlusterfs(){
            return and();
    }

}
    public class HostPathNestedImpl<N> extends HostPathVolumeSourceFluentImpl<PersistentVolumeSpecFluent.HostPathNested<N>> implements PersistentVolumeSpecFluent.HostPathNested<N>,Nested<N>{

            private final HostPathVolumeSourceBuilder builder;
    
            HostPathNestedImpl(){
                    this.builder = new HostPathVolumeSourceBuilder(this);
            }
            HostPathNestedImpl(HostPathVolumeSource item){
                    this.builder = new HostPathVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withHostPath(builder.build());
    }
    public N endHostPath(){
            return and();
    }

}
    public class IscsiNestedImpl<N> extends ISCSIVolumeSourceFluentImpl<PersistentVolumeSpecFluent.IscsiNested<N>> implements PersistentVolumeSpecFluent.IscsiNested<N>,Nested<N>{

            private final ISCSIVolumeSourceBuilder builder;
    
            IscsiNestedImpl(ISCSIVolumeSource item){
                    this.builder = new ISCSIVolumeSourceBuilder(this, item);
            }
            IscsiNestedImpl(){
                    this.builder = new ISCSIVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withIscsi(builder.build());
    }
    public N endIscsi(){
            return and();
    }

}
    public class NfsNestedImpl<N> extends NFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.NfsNested<N>> implements PersistentVolumeSpecFluent.NfsNested<N>,Nested<N>{

            private final NFSVolumeSourceBuilder builder;
    
            NfsNestedImpl(NFSVolumeSource item){
                    this.builder = new NFSVolumeSourceBuilder(this, item);
            }
            NfsNestedImpl(){
                    this.builder = new NFSVolumeSourceBuilder(this);
            }
    
    public N endNfs(){
            return and();
    }
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withNfs(builder.build());
    }

}
    public class RbdNestedImpl<N> extends RBDVolumeSourceFluentImpl<PersistentVolumeSpecFluent.RbdNested<N>> implements PersistentVolumeSpecFluent.RbdNested<N>,Nested<N>{

            private final RBDVolumeSourceBuilder builder;
    
            RbdNestedImpl(){
                    this.builder = new RBDVolumeSourceBuilder(this);
            }
            RbdNestedImpl(RBDVolumeSource item){
                    this.builder = new RBDVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withRbd(builder.build());
    }
    public N endRbd(){
            return and();
    }

}


}
