package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ServiceFluent<A extends ServiceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ServiceFluent.MetadataNested<A> withNewMetadata();
    public ServiceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServiceFluent.MetadataNested<A> editMetadata();
    public ServiceSpec getSpec();
    public A withSpec(ServiceSpec spec);
    public ServiceFluent.SpecNested<A> withNewSpec();
    public ServiceFluent.SpecNested<A> withNewSpecLike(ServiceSpec item);
    public ServiceFluent.SpecNested<A> editSpec();
    public ServiceStatus getStatus();
    public A withStatus(ServiceStatus status);
    public ServiceFluent.StatusNested<A> withNewStatus();
    public ServiceFluent.StatusNested<A> withNewStatusLike(ServiceStatus item);
    public ServiceFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ServiceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ServiceSpecFluent<ServiceFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,ServiceStatusFluent<ServiceFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
