package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public interface DaemonSetSpecFluent<A extends DaemonSetSpecFluent<A>> extends Fluent<A>{


    public LabelSelector getSelector();
    public A withSelector(LabelSelector selector);
    public DaemonSetSpecFluent.SelectorNested<A> withNewSelector();
    public DaemonSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public DaemonSetSpecFluent.SelectorNested<A> editSelector();
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public DaemonSetSpecFluent.TemplateNested<A> withNewTemplate();
    public DaemonSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public DaemonSetSpecFluent.TemplateNested<A> editTemplate();

    public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<DaemonSetSpecFluent.SelectorNested<N>>{

        
    public N endSelector();    public N and();
}
    public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<DaemonSetSpecFluent.TemplateNested<N>>{

        
    public N endTemplate();    public N and();
}


}
