package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface BuildRequestFluent<A extends BuildRequestFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public BinaryBuildSource getBinary();
    public A withBinary(BinaryBuildSource binary);
    public BuildRequestFluent.BinaryNested<A> withNewBinary();
    public BuildRequestFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item);
    public BuildRequestFluent.BinaryNested<A> editBinary();
    public A withNewBinary(String asFile);
    public A addToEnv(EnvVar... items);
    public A removeFromEnv(EnvVar... items);
    public List<EnvVar> getEnv();
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public BuildRequestFluent.EnvNested<A> addNewEnv();
    public BuildRequestFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public BuildRequestFluent.FromNested<A> withNewFrom();
    public BuildRequestFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public BuildRequestFluent.FromNested<A> editFrom();
    public String getKind();
    public A withKind(String kind);
    public Integer getLastVersion();
    public A withLastVersion(Integer lastVersion);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public BuildRequestFluent.MetadataNested<A> withNewMetadata();
    public BuildRequestFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public BuildRequestFluent.MetadataNested<A> editMetadata();
    public SourceRevision getRevision();
    public A withRevision(SourceRevision revision);
    public BuildRequestFluent.RevisionNested<A> withNewRevision();
    public BuildRequestFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item);
    public BuildRequestFluent.RevisionNested<A> editRevision();
    public ObjectReference getTriggeredByImage();
    public A withTriggeredByImage(ObjectReference triggeredByImage);
    public BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImage();
    public BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImageLike(ObjectReference item);
    public BuildRequestFluent.TriggeredByImageNested<A> editTriggeredByImage();

    public interface BinaryNested<N> extends Nested<N>,BinaryBuildSourceFluent<BuildRequestFluent.BinaryNested<N>>{

        
    public N and();    public N endBinary();
}
    public interface EnvNested<N> extends Nested<N>,EnvVarFluent<BuildRequestFluent.EnvNested<N>>{

        
    public N endEnv();    public N and();
}
    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<BuildRequestFluent.FromNested<N>>{

        
    public N endFrom();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<BuildRequestFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RevisionNested<N> extends Nested<N>,SourceRevisionFluent<BuildRequestFluent.RevisionNested<N>>{

        
    public N endRevision();    public N and();
}
    public interface TriggeredByImageNested<N> extends Nested<N>,ObjectReferenceFluent<BuildRequestFluent.TriggeredByImageNested<N>>{

        
    public N and();    public N endTriggeredByImage();
}


}
