package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface TemplateListFluent<A extends TemplateListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Template... items);
    public A removeFromItems(Template... items);
    public List<Template> getItems();
    public A withItems(List<Template> items);
    public A withItems(Template... items);
    public TemplateListFluent.ItemsNested<A> addNewItem();
    public TemplateListFluent.ItemsNested<A> addNewItemLike(Template item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public TemplateListFluent.MetadataNested<A> withNewMetadata();
    public TemplateListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public TemplateListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,TemplateFluent<TemplateListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<TemplateListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
