/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.MetadataVolumeSource;
import io.fabric8.kubernetes.api.model.MetadataVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.MetadataVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class MetadataVolumeSourceBuilder
extends MetadataVolumeSourceFluentImpl<MetadataVolumeSourceBuilder>
implements VisitableBuilder<MetadataVolumeSource, MetadataVolumeSourceBuilder> {
    MetadataVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public MetadataVolumeSourceBuilder() {
        this(true);
    }

    public MetadataVolumeSourceBuilder(Boolean validationEnabled) {
        this(new MetadataVolumeSource(), validationEnabled);
    }

    public MetadataVolumeSourceBuilder(MetadataVolumeSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public MetadataVolumeSourceBuilder(MetadataVolumeSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MetadataVolumeSource(), validationEnabled);
    }

    public MetadataVolumeSourceBuilder(MetadataVolumeSourceFluent<?> fluent, MetadataVolumeSource instance) {
        this(fluent, instance, true);
    }

    public MetadataVolumeSourceBuilder(MetadataVolumeSourceFluent<?> fluent, MetadataVolumeSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withItems(instance.getItems());
        this.validationEnabled = validationEnabled;
    }

    public MetadataVolumeSourceBuilder(MetadataVolumeSource instance) {
        this(instance, (Boolean)true);
    }

    public MetadataVolumeSourceBuilder(MetadataVolumeSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withItems(instance.getItems());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public MetadataVolumeSource build() {
        MetadataVolumeSource buildable = new MetadataVolumeSource(this.fluent.getItems());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetadataVolumeSourceBuilder that = (MetadataVolumeSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

