package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class ContainerFluentImpl<A extends ContainerFluent<A>> extends BaseFluent<A> implements ContainerFluent<A>{

    private List<String> args = new ArrayList<String>();
    private List<String> command = new ArrayList<String>();
    private List<VisitableBuilder<? extends EnvVar,?>> env =  new ArrayList<VisitableBuilder<? extends EnvVar,?>>();
    private String image;
    private String imagePullPolicy;
    private VisitableBuilder<? extends Lifecycle,?> lifecycle;
    private VisitableBuilder<? extends Probe,?> livenessProbe;
    private String name;
    private List<VisitableBuilder<? extends ContainerPort,?>> ports =  new ArrayList<VisitableBuilder<? extends ContainerPort,?>>();
    private VisitableBuilder<? extends Probe,?> readinessProbe;
    private VisitableBuilder<? extends ResourceRequirements,?> resources;
    private VisitableBuilder<? extends SecurityContext,?> securityContext;
    private Boolean stdin;
    private Boolean stdinOnce;
    private String terminationMessagePath;
    private Boolean tty;
    private List<VisitableBuilder<? extends VolumeMount,?>> volumeMounts =  new ArrayList<VisitableBuilder<? extends VolumeMount,?>>();
    private String workingDir;

    public ContainerFluentImpl(){
    }
    public ContainerFluentImpl(Container instance){
            this.withArgs(instance.getArgs()); 
            this.withCommand(instance.getCommand()); 
            this.withEnv(instance.getEnv()); 
            this.withImage(instance.getImage()); 
            this.withImagePullPolicy(instance.getImagePullPolicy()); 
            this.withLifecycle(instance.getLifecycle()); 
            this.withLivenessProbe(instance.getLivenessProbe()); 
            this.withName(instance.getName()); 
            this.withPorts(instance.getPorts()); 
            this.withReadinessProbe(instance.getReadinessProbe()); 
            this.withResources(instance.getResources()); 
            this.withSecurityContext(instance.getSecurityContext()); 
            this.withStdin(instance.getStdin()); 
            this.withStdinOnce(instance.getStdinOnce()); 
            this.withTerminationMessagePath(instance.getTerminationMessagePath()); 
            this.withTty(instance.getTty()); 
            this.withVolumeMounts(instance.getVolumeMounts()); 
            this.withWorkingDir(instance.getWorkingDir()); 
    }

    public A addToArgs(String... items){
            for (String item : items) {this.args.add(item);} return (A)this;
    }

    public A removeFromArgs(String... items){
            for (String item : items) {this.args.remove(item);} return (A)this;
    }

    public List<String> getArgs(){
            return this.args;
    }

    public A withArgs(List<String> args){
            this.args.clear();
            if (args != null) {for (String item : args){this.addToArgs(item);}} return (A) this;
    }

    public A withArgs(String... args){
            this.args.clear(); if (args != null) {for (String item :args){ this.addToArgs(item);}} return (A) this;
    }

    public A addToCommand(String... items){
            for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A removeFromCommand(String... items){
            for (String item : items) {this.command.remove(item);} return (A)this;
    }

    public List<String> getCommand(){
            return this.command;
    }

    public A withCommand(List<String> command){
            this.command.clear();
            if (command != null) {for (String item : command){this.addToCommand(item);}} return (A) this;
    }

    public A withCommand(String... command){
            this.command.clear(); if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
    }

    public A addToEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (A)this;
    }

    public List<EnvVar> getEnv(){
            return build(env);
    }

    public A withEnv(List<EnvVar> env){
            this.env.clear();
            if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (A) this;
    }

    public A withEnv(EnvVar... env){
            this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public ContainerFluent.EnvNested<A> addNewEnv(){
            return new EnvNestedImpl();
    }

    public ContainerFluent.EnvNested<A> addNewEnvLike(EnvVar item){
            return new EnvNestedImpl(item);
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public String getImagePullPolicy(){
            return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy){
            this.imagePullPolicy=imagePullPolicy; return (A) this;
    }

    public Lifecycle getLifecycle(){
            return this.lifecycle!=null?this.lifecycle.build():null;
    }

    public A withLifecycle(Lifecycle lifecycle){
            if (lifecycle!=null){ this.lifecycle= new LifecycleBuilder(lifecycle); _visitables.add(this.lifecycle);} return (A) this;
    }

    public ContainerFluent.LifecycleNested<A> withNewLifecycle(){
            return new LifecycleNestedImpl();
    }

    public ContainerFluent.LifecycleNested<A> withNewLifecycleLike(Lifecycle item){
            return new LifecycleNestedImpl(item);
    }

    public ContainerFluent.LifecycleNested<A> editLifecycle(){
            return withNewLifecycleLike(getLifecycle());
    }

    public Probe getLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(Probe livenessProbe){
            if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.add(this.livenessProbe);} return (A) this;
    }

    public ContainerFluent.LivenessProbeNested<A> withNewLivenessProbe(){
            return new LivenessProbeNestedImpl();
    }

    public ContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item){
            return new LivenessProbeNestedImpl(item);
    }

    public ContainerFluent.LivenessProbeNested<A> editLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe());
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public A addToPorts(ContainerPort... items){
            for (ContainerPort item : items) {ContainerPortBuilder builder = new ContainerPortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(ContainerPort... items){
            for (ContainerPort item : items) {ContainerPortBuilder builder = new ContainerPortBuilder(item);_visitables.remove(builder);this.ports.remove(builder);} return (A)this;
    }

    public List<ContainerPort> getPorts(){
            return build(ports);
    }

    public A withPorts(List<ContainerPort> ports){
            this.ports.clear();
            if (ports != null) {for (ContainerPort item : ports){this.addToPorts(item);}} return (A) this;
    }

    public A withPorts(ContainerPort... ports){
            this.ports.clear(); if (ports != null) {for (ContainerPort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public ContainerFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public ContainerFluent.PortsNested<A> addNewPortLike(ContainerPort item){
            return new PortsNestedImpl(item);
    }

    public A addNewPort(Integer containerPort,String hostIP,Integer hostPort,String name,String protocol){
            return (A)addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }

    public Probe getReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(Probe readinessProbe){
            if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.add(this.readinessProbe);} return (A) this;
    }

    public ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe(){
            return new ReadinessProbeNestedImpl();
    }

    public ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item){
            return new ReadinessProbeNestedImpl(item);
    }

    public ContainerFluent.ReadinessProbeNested<A> editReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe());
    }

    public ResourceRequirements getResources(){
            return this.resources!=null?this.resources.build():null;
    }

    public A withResources(ResourceRequirements resources){
            if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (A) this;
    }

    public ContainerFluent.ResourcesNested<A> withNewResources(){
            return new ResourcesNestedImpl();
    }

    public ContainerFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item){
            return new ResourcesNestedImpl(item);
    }

    public ContainerFluent.ResourcesNested<A> editResources(){
            return withNewResourcesLike(getResources());
    }

    public SecurityContext getSecurityContext(){
            return this.securityContext!=null?this.securityContext.build():null;
    }

    public A withSecurityContext(SecurityContext securityContext){
            if (securityContext!=null){ this.securityContext= new SecurityContextBuilder(securityContext); _visitables.add(this.securityContext);} return (A) this;
    }

    public ContainerFluent.SecurityContextNested<A> withNewSecurityContext(){
            return new SecurityContextNestedImpl();
    }

    public ContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(SecurityContext item){
            return new SecurityContextNestedImpl(item);
    }

    public ContainerFluent.SecurityContextNested<A> editSecurityContext(){
            return withNewSecurityContextLike(getSecurityContext());
    }

    public Boolean isStdin(){
            return this.stdin;
    }

    public A withStdin(Boolean stdin){
            this.stdin=stdin; return (A) this;
    }

    public Boolean isStdinOnce(){
            return this.stdinOnce;
    }

    public A withStdinOnce(Boolean stdinOnce){
            this.stdinOnce=stdinOnce; return (A) this;
    }

    public String getTerminationMessagePath(){
            return this.terminationMessagePath;
    }

    public A withTerminationMessagePath(String terminationMessagePath){
            this.terminationMessagePath=terminationMessagePath; return (A) this;
    }

    public Boolean isTty(){
            return this.tty;
    }

    public A withTty(Boolean tty){
            this.tty=tty; return (A) this;
    }

    public A addToVolumeMounts(VolumeMount... items){
            for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A removeFromVolumeMounts(VolumeMount... items){
            for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.remove(builder);this.volumeMounts.remove(builder);} return (A)this;
    }

    public List<VolumeMount> getVolumeMounts(){
            return build(volumeMounts);
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts){
            this.volumeMounts.clear();
            if (volumeMounts != null) {for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} return (A) this;
    }

    public A withVolumeMounts(VolumeMount... volumeMounts){
            this.volumeMounts.clear(); if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public ContainerFluent.VolumeMountsNested<A> addNewVolumeMount(){
            return new VolumeMountsNestedImpl();
    }

    public ContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item){
            return new VolumeMountsNestedImpl(item);
    }

    public A addNewVolumeMount(String mountPath,String name,Boolean readOnly){
            return (A)addToVolumeMounts(new VolumeMount(mountPath, name, readOnly));
    }

    public String getWorkingDir(){
            return this.workingDir;
    }

    public A withWorkingDir(String workingDir){
            this.workingDir=workingDir; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerFluentImpl that = (ContainerFluentImpl) o;
            if (args != null ? !args.equals(that.args) :that.args != null) return false;
            if (command != null ? !command.equals(that.command) :that.command != null) return false;
            if (env != null ? !env.equals(that.env) :that.env != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (imagePullPolicy != null ? !imagePullPolicy.equals(that.imagePullPolicy) :that.imagePullPolicy != null) return false;
            if (lifecycle != null ? !lifecycle.equals(that.lifecycle) :that.lifecycle != null) return false;
            if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
            if (stdin != null ? !stdin.equals(that.stdin) :that.stdin != null) return false;
            if (stdinOnce != null ? !stdinOnce.equals(that.stdinOnce) :that.stdinOnce != null) return false;
            if (terminationMessagePath != null ? !terminationMessagePath.equals(that.terminationMessagePath) :that.terminationMessagePath != null) return false;
            if (tty != null ? !tty.equals(that.tty) :that.tty != null) return false;
            if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
            if (workingDir != null ? !workingDir.equals(that.workingDir) :that.workingDir != null) return false;
            return true;
    }


    public class EnvNestedImpl<N> extends EnvVarFluentImpl<ContainerFluent.EnvNested<N>> implements ContainerFluent.EnvNested<N>,Nested<N>{

            private final EnvVarBuilder builder;
    
            EnvNestedImpl(EnvVar item){
                    this.builder = new EnvVarBuilder(this, item);
            }
            EnvNestedImpl(){
                    this.builder = new EnvVarBuilder(this);
            }
    
    public N endEnv(){
            return and();
    }
    public N and(){
            return (N) ContainerFluentImpl.this.addToEnv(builder.build());
    }

}
    public class LifecycleNestedImpl<N> extends LifecycleFluentImpl<ContainerFluent.LifecycleNested<N>> implements ContainerFluent.LifecycleNested<N>,Nested<N>{

            private final LifecycleBuilder builder;
    
            LifecycleNestedImpl(){
                    this.builder = new LifecycleBuilder(this);
            }
            LifecycleNestedImpl(Lifecycle item){
                    this.builder = new LifecycleBuilder(this, item);
            }
    
    public N endLifecycle(){
            return and();
    }
    public N and(){
            return (N) ContainerFluentImpl.this.withLifecycle(builder.build());
    }

}
    public class LivenessProbeNestedImpl<N> extends ProbeFluentImpl<ContainerFluent.LivenessProbeNested<N>> implements ContainerFluent.LivenessProbeNested<N>,Nested<N>{

            private final ProbeBuilder builder;
    
            LivenessProbeNestedImpl(){
                    this.builder = new ProbeBuilder(this);
            }
            LivenessProbeNestedImpl(Probe item){
                    this.builder = new ProbeBuilder(this, item);
            }
    
    public N endLivenessProbe(){
            return and();
    }
    public N and(){
            return (N) ContainerFluentImpl.this.withLivenessProbe(builder.build());
    }

}
    public class PortsNestedImpl<N> extends ContainerPortFluentImpl<ContainerFluent.PortsNested<N>> implements ContainerFluent.PortsNested<N>,Nested<N>{

            private final ContainerPortBuilder builder;
    
            PortsNestedImpl(ContainerPort item){
                    this.builder = new ContainerPortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.builder = new ContainerPortBuilder(this);
            }
    
    public N endPort(){
            return and();
    }
    public N and(){
            return (N) ContainerFluentImpl.this.addToPorts(builder.build());
    }

}
    public class ReadinessProbeNestedImpl<N> extends ProbeFluentImpl<ContainerFluent.ReadinessProbeNested<N>> implements ContainerFluent.ReadinessProbeNested<N>,Nested<N>{

            private final ProbeBuilder builder;
    
            ReadinessProbeNestedImpl(){
                    this.builder = new ProbeBuilder(this);
            }
            ReadinessProbeNestedImpl(Probe item){
                    this.builder = new ProbeBuilder(this, item);
            }
    
    public N endReadinessProbe(){
            return and();
    }
    public N and(){
            return (N) ContainerFluentImpl.this.withReadinessProbe(builder.build());
    }

}
    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ContainerFluent.ResourcesNested<N>> implements ContainerFluent.ResourcesNested<N>,Nested<N>{

            private final ResourceRequirementsBuilder builder;
    
            ResourcesNestedImpl(){
                    this.builder = new ResourceRequirementsBuilder(this);
            }
            ResourcesNestedImpl(ResourceRequirements item){
                    this.builder = new ResourceRequirementsBuilder(this, item);
            }
    
    public N and(){
            return (N) ContainerFluentImpl.this.withResources(builder.build());
    }
    public N endResources(){
            return and();
    }

}
    public class SecurityContextNestedImpl<N> extends SecurityContextFluentImpl<ContainerFluent.SecurityContextNested<N>> implements ContainerFluent.SecurityContextNested<N>,Nested<N>{

            private final SecurityContextBuilder builder;
    
            SecurityContextNestedImpl(){
                    this.builder = new SecurityContextBuilder(this);
            }
            SecurityContextNestedImpl(SecurityContext item){
                    this.builder = new SecurityContextBuilder(this, item);
            }
    
    public N and(){
            return (N) ContainerFluentImpl.this.withSecurityContext(builder.build());
    }
    public N endSecurityContext(){
            return and();
    }

}
    public class VolumeMountsNestedImpl<N> extends VolumeMountFluentImpl<ContainerFluent.VolumeMountsNested<N>> implements ContainerFluent.VolumeMountsNested<N>,Nested<N>{

            private final VolumeMountBuilder builder;
    
            VolumeMountsNestedImpl(){
                    this.builder = new VolumeMountBuilder(this);
            }
            VolumeMountsNestedImpl(VolumeMount item){
                    this.builder = new VolumeMountBuilder(this, item);
            }
    
    public N and(){
            return (N) ContainerFluentImpl.this.addToVolumeMounts(builder.build());
    }
    public N endVolumeMount(){
            return and();
    }

}


}
