package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface LoadBalancerStatusFluent<A extends LoadBalancerStatusFluent<A>> extends Fluent<A>{


    public A addToIngress(LoadBalancerIngress... items);
    public A removeFromIngress(LoadBalancerIngress... items);
    public List<LoadBalancerIngress> getIngress();
    public A withIngress(List<LoadBalancerIngress> ingress);
    public A withIngress(LoadBalancerIngress... ingress);
    public LoadBalancerStatusFluent.IngressNested<A> addNewIngress();
    public LoadBalancerStatusFluent.IngressNested<A> addNewIngressLike(LoadBalancerIngress item);
    public A addNewIngress(String hostname,String ip);

    public interface IngressNested<N> extends Nested<N>,LoadBalancerIngressFluent<LoadBalancerStatusFluent.IngressNested<N>>{

        
    public N endIngress();    public N and();
}


}
