package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class PersistentVolumeSpecBuilder extends PersistentVolumeSpecFluentImpl<PersistentVolumeSpecBuilder> implements VisitableBuilder<PersistentVolumeSpec,PersistentVolumeSpecBuilder>{

    PersistentVolumeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PersistentVolumeSpecBuilder(){
            this(true);
    }
    public PersistentVolumeSpecBuilder(Boolean validationEnabled){
            this(new PersistentVolumeSpec(), validationEnabled);
    }
    public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent){
            this(fluent, true);
    }
    public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PersistentVolumeSpec(), validationEnabled);
    }
    public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent,PersistentVolumeSpec instance){
            this(fluent, instance, true);
    }
    public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent,PersistentVolumeSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccessModes(instance.getAccessModes()); 
            fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); 
            fluent.withAzureFile(instance.getAzureFile()); 
            fluent.withCapacity(instance.getCapacity()); 
            fluent.withCephfs(instance.getCephfs()); 
            fluent.withCinder(instance.getCinder()); 
            fluent.withClaimRef(instance.getClaimRef()); 
            fluent.withFc(instance.getFc()); 
            fluent.withFlexVolume(instance.getFlexVolume()); 
            fluent.withFlocker(instance.getFlocker()); 
            fluent.withGcePersistentDisk(instance.getGcePersistentDisk()); 
            fluent.withGlusterfs(instance.getGlusterfs()); 
            fluent.withHostPath(instance.getHostPath()); 
            fluent.withIscsi(instance.getIscsi()); 
            fluent.withNfs(instance.getNfs()); 
            fluent.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy()); 
            fluent.withRbd(instance.getRbd()); 
            this.validationEnabled = validationEnabled; 
    }
    public PersistentVolumeSpecBuilder(PersistentVolumeSpec instance){
            this(instance,true);
    }
    public PersistentVolumeSpecBuilder(PersistentVolumeSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccessModes(instance.getAccessModes()); 
            this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); 
            this.withAzureFile(instance.getAzureFile()); 
            this.withCapacity(instance.getCapacity()); 
            this.withCephfs(instance.getCephfs()); 
            this.withCinder(instance.getCinder()); 
            this.withClaimRef(instance.getClaimRef()); 
            this.withFc(instance.getFc()); 
            this.withFlexVolume(instance.getFlexVolume()); 
            this.withFlocker(instance.getFlocker()); 
            this.withGcePersistentDisk(instance.getGcePersistentDisk()); 
            this.withGlusterfs(instance.getGlusterfs()); 
            this.withHostPath(instance.getHostPath()); 
            this.withIscsi(instance.getIscsi()); 
            this.withNfs(instance.getNfs()); 
            this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy()); 
            this.withRbd(instance.getRbd()); 
            this.validationEnabled = validationEnabled; 
    }

    public PersistentVolumeSpec build(){
            PersistentVolumeSpec buildable = new PersistentVolumeSpec(fluent.getAccessModes(),fluent.getAwsElasticBlockStore(),fluent.getAzureFile(),fluent.getCapacity(),fluent.getCephfs(),fluent.getCinder(),fluent.getClaimRef(),fluent.getFc(),fluent.getFlexVolume(),fluent.getFlocker(),fluent.getGcePersistentDisk(),fluent.getGlusterfs(),fluent.getHostPath(),fluent.getIscsi(),fluent.getNfs(),fluent.getPersistentVolumeReclaimPolicy(),fluent.getRbd());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PersistentVolumeSpecBuilder that = (PersistentVolumeSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
