package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SecurityContextFluent<A extends SecurityContextFluent<A>> extends Fluent<A>{


    public Capabilities getCapabilities();
    public A withCapabilities(Capabilities capabilities);
    public SecurityContextFluent.CapabilitiesNested<A> withNewCapabilities();
    public SecurityContextFluent.CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item);
    public SecurityContextFluent.CapabilitiesNested<A> editCapabilities();
    public Boolean isPrivileged();
    public A withPrivileged(Boolean privileged);
    public Boolean isReadOnlyRootFilesystem();
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
    public Boolean isRunAsNonRoot();
    public A withRunAsNonRoot(Boolean runAsNonRoot);
    public Long getRunAsUser();
    public A withRunAsUser(Long runAsUser);
    public SELinuxOptions getSeLinuxOptions();
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions);
    public SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions();
    public SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item);
    public SecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions();
    public A withNewSeLinuxOptions(String level,String role,String type,String user);

    public interface CapabilitiesNested<N> extends Nested<N>,CapabilitiesFluent<SecurityContextFluent.CapabilitiesNested<N>>{

        
    public N endCapabilities();    public N and();
}
    public interface SeLinuxOptionsNested<N> extends Nested<N>,SELinuxOptionsFluent<SecurityContextFluent.SeLinuxOptionsNested<N>>{

        
    public N endSeLinuxOptions();    public N and();
}


}
