package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public class JobListFluentImpl<A extends JobListFluent<A>> extends BaseFluent<A> implements JobListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends Job,?>> items =  new ArrayList<VisitableBuilder<? extends Job,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public JobListFluentImpl(){
    }
    public JobListFluentImpl(JobList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(Job... items){
            for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Job... items){
            for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<Job> getItems(){
            return build(items);
    }

    public A withItems(List<Job> items){
            this.items.clear();
            if (items != null) {for (Job item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(Job... items){
            this.items.clear(); if (items != null) {for (Job item :items){ this.addToItems(item);}} return (A) this;
    }

    public JobListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public JobListFluent.ItemsNested<A> addNewItemLike(Job item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public JobListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public JobListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public JobListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JobListFluentImpl that = (JobListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends JobFluentImpl<JobListFluent.ItemsNested<N>> implements JobListFluent.ItemsNested<N>,Nested<N>{

            private final JobBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new JobBuilder(this);
            }
            ItemsNestedImpl(Job item){
                    this.builder = new JobBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) JobListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<JobListFluent.MetadataNested<N>> implements JobListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) JobListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
