package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class BuildSpecBuilder extends BuildSpecFluentImpl<BuildSpecBuilder> implements VisitableBuilder<BuildSpec,BuildSpecBuilder>{

    BuildSpecFluent<?> fluent;
    Boolean validationEnabled;

    public BuildSpecBuilder(){
            this(true);
    }
    public BuildSpecBuilder(Boolean validationEnabled){
            this(new BuildSpec(), validationEnabled);
    }
    public BuildSpecBuilder(BuildSpecFluent<?> fluent){
            this(fluent, true);
    }
    public BuildSpecBuilder(BuildSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BuildSpec(), validationEnabled);
    }
    public BuildSpecBuilder(BuildSpecFluent<?> fluent,BuildSpec instance){
            this(fluent, instance, true);
    }
    public BuildSpecBuilder(BuildSpecFluent<?> fluent,BuildSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
            fluent.withOutput(instance.getOutput()); 
            fluent.withPostCommit(instance.getPostCommit()); 
            fluent.withResources(instance.getResources()); 
            fluent.withRevision(instance.getRevision()); 
            fluent.withServiceAccount(instance.getServiceAccount()); 
            fluent.withSource(instance.getSource()); 
            fluent.withStrategy(instance.getStrategy()); 
            this.validationEnabled = validationEnabled; 
    }
    public BuildSpecBuilder(BuildSpec instance){
            this(instance,true);
    }
    public BuildSpecBuilder(BuildSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
            this.withOutput(instance.getOutput()); 
            this.withPostCommit(instance.getPostCommit()); 
            this.withResources(instance.getResources()); 
            this.withRevision(instance.getRevision()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withSource(instance.getSource()); 
            this.withStrategy(instance.getStrategy()); 
            this.validationEnabled = validationEnabled; 
    }

    public BuildSpec build(){
            BuildSpec buildable = new BuildSpec(fluent.getCompletionDeadlineSeconds(),fluent.getOutput(),fluent.getPostCommit(),fluent.getResources(),fluent.getRevision(),fluent.getServiceAccount(),fluent.getSource(),fluent.getStrategy());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildSpecBuilder that = (BuildSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
