package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class DownwardAPIVolumeFileFluentImpl<A extends DownwardAPIVolumeFileFluent<A>> extends BaseFluent<A> implements DownwardAPIVolumeFileFluent<A>{

    private VisitableBuilder<? extends ObjectFieldSelector,?> fieldRef;
    private String path;

    public DownwardAPIVolumeFileFluentImpl(){
    }
    public DownwardAPIVolumeFileFluentImpl(DownwardAPIVolumeFile instance){
            this.withFieldRef(instance.getFieldRef()); 
            this.withPath(instance.getPath()); 
    }

    public ObjectFieldSelector getFieldRef(){
            return this.fieldRef!=null?this.fieldRef.build():null;
    }

    public A withFieldRef(ObjectFieldSelector fieldRef){
            if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.add(this.fieldRef);} return (A) this;
    }

    public DownwardAPIVolumeFileFluent.FieldRefNested<A> withNewFieldRef(){
            return new FieldRefNestedImpl();
    }

    public DownwardAPIVolumeFileFluent.FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item){
            return new FieldRefNestedImpl(item);
    }

    public DownwardAPIVolumeFileFluent.FieldRefNested<A> editFieldRef(){
            return withNewFieldRefLike(getFieldRef());
    }

    public A withNewFieldRef(String apiVersion,String fieldPath){
            return (A)withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DownwardAPIVolumeFileFluentImpl that = (DownwardAPIVolumeFileFluentImpl) o;
            if (fieldRef != null ? !fieldRef.equals(that.fieldRef) :that.fieldRef != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            return true;
    }


    public class FieldRefNestedImpl<N> extends ObjectFieldSelectorFluentImpl<DownwardAPIVolumeFileFluent.FieldRefNested<N>> implements DownwardAPIVolumeFileFluent.FieldRefNested<N>,Nested<N>{

            private final ObjectFieldSelectorBuilder builder;
    
            FieldRefNestedImpl(){
                    this.builder = new ObjectFieldSelectorBuilder(this);
            }
            FieldRefNestedImpl(ObjectFieldSelector item){
                    this.builder = new ObjectFieldSelectorBuilder(this, item);
            }
    
    public N and(){
            return (N) DownwardAPIVolumeFileFluentImpl.this.withFieldRef(builder.build());
    }
    public N endFieldRef(){
            return and();
    }

}


}
