package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface EnvVarSourceFluent<A extends EnvVarSourceFluent<A>> extends Fluent<A>{


    public ConfigMapKeySelector getConfigMapKeyRef();
    public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef);
    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> withNewConfigMapKeyRef();
    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> withNewConfigMapKeyRefLike(ConfigMapKeySelector item);
    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> editConfigMapKeyRef();
    public A withNewConfigMapKeyRef(String key,String name);
    public ObjectFieldSelector getFieldRef();
    public A withFieldRef(ObjectFieldSelector fieldRef);
    public EnvVarSourceFluent.FieldRefNested<A> withNewFieldRef();
    public EnvVarSourceFluent.FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item);
    public EnvVarSourceFluent.FieldRefNested<A> editFieldRef();
    public A withNewFieldRef(String apiVersion,String fieldPath);
    public SecretKeySelector getSecretKeyRef();
    public A withSecretKeyRef(SecretKeySelector secretKeyRef);
    public EnvVarSourceFluent.SecretKeyRefNested<A> withNewSecretKeyRef();
    public EnvVarSourceFluent.SecretKeyRefNested<A> withNewSecretKeyRefLike(SecretKeySelector item);
    public EnvVarSourceFluent.SecretKeyRefNested<A> editSecretKeyRef();
    public A withNewSecretKeyRef(String key,String name);

    public interface ConfigMapKeyRefNested<N> extends Nested<N>,ConfigMapKeySelectorFluent<EnvVarSourceFluent.ConfigMapKeyRefNested<N>>{

        
    public N endConfigMapKeyRef();    public N and();
}
    public interface FieldRefNested<N> extends Nested<N>,ObjectFieldSelectorFluent<EnvVarSourceFluent.FieldRefNested<N>>{

        
    public N and();    public N endFieldRef();
}
    public interface SecretKeyRefNested<N> extends Nested<N>,SecretKeySelectorFluent<EnvVarSourceFluent.SecretKeyRefNested<N>>{

        
    public N endSecretKeyRef();    public N and();
}


}
