package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class EnvVarSourceFluentImpl<A extends EnvVarSourceFluent<A>> extends BaseFluent<A> implements EnvVarSourceFluent<A>{

    private VisitableBuilder<? extends ConfigMapKeySelector,?> configMapKeyRef;
    private VisitableBuilder<? extends ObjectFieldSelector,?> fieldRef;
    private VisitableBuilder<? extends SecretKeySelector,?> secretKeyRef;

    public EnvVarSourceFluentImpl(){
    }
    public EnvVarSourceFluentImpl(EnvVarSource instance){
            this.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
            this.withFieldRef(instance.getFieldRef()); 
            this.withSecretKeyRef(instance.getSecretKeyRef()); 
    }

    public ConfigMapKeySelector getConfigMapKeyRef(){
            return this.configMapKeyRef!=null?this.configMapKeyRef.build():null;
    }

    public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef){
            if (configMapKeyRef!=null){ this.configMapKeyRef= new ConfigMapKeySelectorBuilder(configMapKeyRef); _visitables.add(this.configMapKeyRef);} return (A) this;
    }

    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> withNewConfigMapKeyRef(){
            return new ConfigMapKeyRefNestedImpl();
    }

    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> withNewConfigMapKeyRefLike(ConfigMapKeySelector item){
            return new ConfigMapKeyRefNestedImpl(item);
    }

    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> editConfigMapKeyRef(){
            return withNewConfigMapKeyRefLike(getConfigMapKeyRef());
    }

    public A withNewConfigMapKeyRef(String key,String name){
            return (A)withConfigMapKeyRef(new ConfigMapKeySelector(key, name));
    }

    public ObjectFieldSelector getFieldRef(){
            return this.fieldRef!=null?this.fieldRef.build():null;
    }

    public A withFieldRef(ObjectFieldSelector fieldRef){
            if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.add(this.fieldRef);} return (A) this;
    }

    public EnvVarSourceFluent.FieldRefNested<A> withNewFieldRef(){
            return new FieldRefNestedImpl();
    }

    public EnvVarSourceFluent.FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item){
            return new FieldRefNestedImpl(item);
    }

    public EnvVarSourceFluent.FieldRefNested<A> editFieldRef(){
            return withNewFieldRefLike(getFieldRef());
    }

    public A withNewFieldRef(String apiVersion,String fieldPath){
            return (A)withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }

    public SecretKeySelector getSecretKeyRef(){
            return this.secretKeyRef!=null?this.secretKeyRef.build():null;
    }

    public A withSecretKeyRef(SecretKeySelector secretKeyRef){
            if (secretKeyRef!=null){ this.secretKeyRef= new SecretKeySelectorBuilder(secretKeyRef); _visitables.add(this.secretKeyRef);} return (A) this;
    }

    public EnvVarSourceFluent.SecretKeyRefNested<A> withNewSecretKeyRef(){
            return new SecretKeyRefNestedImpl();
    }

    public EnvVarSourceFluent.SecretKeyRefNested<A> withNewSecretKeyRefLike(SecretKeySelector item){
            return new SecretKeyRefNestedImpl(item);
    }

    public EnvVarSourceFluent.SecretKeyRefNested<A> editSecretKeyRef(){
            return withNewSecretKeyRefLike(getSecretKeyRef());
    }

    public A withNewSecretKeyRef(String key,String name){
            return (A)withSecretKeyRef(new SecretKeySelector(key, name));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvVarSourceFluentImpl that = (EnvVarSourceFluentImpl) o;
            if (configMapKeyRef != null ? !configMapKeyRef.equals(that.configMapKeyRef) :that.configMapKeyRef != null) return false;
            if (fieldRef != null ? !fieldRef.equals(that.fieldRef) :that.fieldRef != null) return false;
            if (secretKeyRef != null ? !secretKeyRef.equals(that.secretKeyRef) :that.secretKeyRef != null) return false;
            return true;
    }


    public class ConfigMapKeyRefNestedImpl<N> extends ConfigMapKeySelectorFluentImpl<EnvVarSourceFluent.ConfigMapKeyRefNested<N>> implements EnvVarSourceFluent.ConfigMapKeyRefNested<N>,Nested<N>{

            private final ConfigMapKeySelectorBuilder builder;
    
            ConfigMapKeyRefNestedImpl(){
                    this.builder = new ConfigMapKeySelectorBuilder(this);
            }
            ConfigMapKeyRefNestedImpl(ConfigMapKeySelector item){
                    this.builder = new ConfigMapKeySelectorBuilder(this, item);
            }
    
    public N endConfigMapKeyRef(){
            return and();
    }
    public N and(){
            return (N) EnvVarSourceFluentImpl.this.withConfigMapKeyRef(builder.build());
    }

}
    public class FieldRefNestedImpl<N> extends ObjectFieldSelectorFluentImpl<EnvVarSourceFluent.FieldRefNested<N>> implements EnvVarSourceFluent.FieldRefNested<N>,Nested<N>{

            private final ObjectFieldSelectorBuilder builder;
    
            FieldRefNestedImpl(){
                    this.builder = new ObjectFieldSelectorBuilder(this);
            }
            FieldRefNestedImpl(ObjectFieldSelector item){
                    this.builder = new ObjectFieldSelectorBuilder(this, item);
            }
    
    public N and(){
            return (N) EnvVarSourceFluentImpl.this.withFieldRef(builder.build());
    }
    public N endFieldRef(){
            return and();
    }

}
    public class SecretKeyRefNestedImpl<N> extends SecretKeySelectorFluentImpl<EnvVarSourceFluent.SecretKeyRefNested<N>> implements EnvVarSourceFluent.SecretKeyRefNested<N>,Nested<N>{

            private final SecretKeySelectorBuilder builder;
    
            SecretKeyRefNestedImpl(){
                    this.builder = new SecretKeySelectorBuilder(this);
            }
            SecretKeyRefNestedImpl(SecretKeySelector item){
                    this.builder = new SecretKeySelectorBuilder(this, item);
            }
    
    public N endSecretKeyRef(){
            return and();
    }
    public N and(){
            return (N) EnvVarSourceFluentImpl.this.withSecretKeyRef(builder.build());
    }

}


}
