package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class MetadataFileBuilder extends MetadataFileFluentImpl<MetadataFileBuilder> implements VisitableBuilder<MetadataFile,MetadataFileBuilder>{

    MetadataFileFluent<?> fluent;
    Boolean validationEnabled;

    public MetadataFileBuilder(){
            this(true);
    }
    public MetadataFileBuilder(Boolean validationEnabled){
            this(new MetadataFile(), validationEnabled);
    }
    public MetadataFileBuilder(MetadataFileFluent<?> fluent){
            this(fluent, true);
    }
    public MetadataFileBuilder(MetadataFileFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MetadataFile(), validationEnabled);
    }
    public MetadataFileBuilder(MetadataFileFluent<?> fluent,MetadataFile instance){
            this(fluent, instance, true);
    }
    public MetadataFileBuilder(MetadataFileFluent<?> fluent,MetadataFile instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFieldRef(instance.getFieldRef()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetadataFileBuilder(MetadataFile instance){
            this(instance,true);
    }
    public MetadataFileBuilder(MetadataFile instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFieldRef(instance.getFieldRef()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public MetadataFile build(){
            MetadataFile buildable = new MetadataFile(fluent.getFieldRef(),fluent.getName());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetadataFileBuilder that = (MetadataFileBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
