package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.util.Map;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NodeStatusFluent<A extends NodeStatusFluent<A>> extends Fluent<A>{


    public A addToAddresses(NodeAddress... items);
    public A removeFromAddresses(NodeAddress... items);
    public List<NodeAddress> getAddresses();
    public A withAddresses(List<NodeAddress> addresses);
    public A withAddresses(NodeAddress... addresses);
    public NodeStatusFluent.AddressesNested<A> addNewAddress();
    public NodeStatusFluent.AddressesNested<A> addNewAddressLike(NodeAddress item);
    public A addNewAddress(String address,String type);
    public A addToAllocatable(String key,Quantity value);
    public A addToAllocatable(Map<String,Quantity> map);
    public A removeFromAllocatable(String key);
    public A removeFromAllocatable(Map<String,Quantity> map);
    public Map<String,Quantity> getAllocatable();
    public A withAllocatable(Map<String,Quantity> allocatable);
    public A addToCapacity(String key,Quantity value);
    public A addToCapacity(Map<String,Quantity> map);
    public A removeFromCapacity(String key);
    public A removeFromCapacity(Map<String,Quantity> map);
    public Map<String,Quantity> getCapacity();
    public A withCapacity(Map<String,Quantity> capacity);
    public A addToConditions(NodeCondition... items);
    public A removeFromConditions(NodeCondition... items);
    public List<NodeCondition> getConditions();
    public A withConditions(List<NodeCondition> conditions);
    public A withConditions(NodeCondition... conditions);
    public NodeStatusFluent.ConditionsNested<A> addNewCondition();
    public NodeStatusFluent.ConditionsNested<A> addNewConditionLike(NodeCondition item);
    public NodeDaemonEndpoints getDaemonEndpoints();
    public A withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints);
    public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpoints();
    public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpointsLike(NodeDaemonEndpoints item);
    public NodeStatusFluent.DaemonEndpointsNested<A> editDaemonEndpoints();
    public A addToImages(ContainerImage... items);
    public A removeFromImages(ContainerImage... items);
    public List<ContainerImage> getImages();
    public A withImages(List<ContainerImage> images);
    public A withImages(ContainerImage... images);
    public NodeStatusFluent.ImagesNested<A> addNewImage();
    public NodeStatusFluent.ImagesNested<A> addNewImageLike(ContainerImage item);
    public NodeSystemInfo getNodeInfo();
    public A withNodeInfo(NodeSystemInfo nodeInfo);
    public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfo();
    public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item);
    public NodeStatusFluent.NodeInfoNested<A> editNodeInfo();
    public String getPhase();
    public A withPhase(String phase);

    public interface AddressesNested<N> extends Nested<N>,NodeAddressFluent<NodeStatusFluent.AddressesNested<N>>{

        
    public N endAddress();    public N and();
}
    public interface ConditionsNested<N> extends Nested<N>,NodeConditionFluent<NodeStatusFluent.ConditionsNested<N>>{

        
    public N endCondition();    public N and();
}
    public interface DaemonEndpointsNested<N> extends Nested<N>,NodeDaemonEndpointsFluent<NodeStatusFluent.DaemonEndpointsNested<N>>{

        
    public N endDaemonEndpoints();    public N and();
}
    public interface ImagesNested<N> extends Nested<N>,ContainerImageFluent<NodeStatusFluent.ImagesNested<N>>{

        
    public N and();    public N endImage();
}
    public interface NodeInfoNested<N> extends Nested<N>,NodeSystemInfoFluent<NodeStatusFluent.NodeInfoNested<N>>{

        
    public N and();    public N endNodeInfo();
}


}
