package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.Integer;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>> extends BaseFluent<A> implements IngressBackendFluent<A>{

    private String serviceName;
    private VisitableBuilder<? extends IntOrString,?> servicePort;

    public IngressBackendFluentImpl(){
    }
    public IngressBackendFluentImpl(IngressBackend instance){
            this.withServiceName(instance.getServiceName()); 
            this.withServicePort(instance.getServicePort()); 
    }

    public String getServiceName(){
            return this.serviceName;
    }

    public A withServiceName(String serviceName){
            this.serviceName=serviceName; return (A) this;
    }

    public IntOrString getServicePort(){
            return this.servicePort!=null?this.servicePort.build():null;
    }

    public A withServicePort(IntOrString servicePort){
            if (servicePort!=null){ this.servicePort= new IntOrStringBuilder(servicePort); _visitables.add(this.servicePort);} return (A) this;
    }

    public IngressBackendFluent.ServicePortNested<A> withNewServicePort(){
            return new ServicePortNestedImpl();
    }

    public IngressBackendFluent.ServicePortNested<A> withNewServicePortLike(IntOrString item){
            return new ServicePortNestedImpl(item);
    }

    public IngressBackendFluent.ServicePortNested<A> editServicePort(){
            return withNewServicePortLike(getServicePort());
    }

    public A withNewServicePort(String strVal){
            return (A)withServicePort(new IntOrString(strVal));
    }

    public A withNewServicePort(Integer intVal){
            return (A)withServicePort(new IntOrString(intVal));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressBackendFluentImpl that = (IngressBackendFluentImpl) o;
            if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
            if (servicePort != null ? !servicePort.equals(that.servicePort) :that.servicePort != null) return false;
            return true;
    }


    public class ServicePortNestedImpl<N> extends IntOrStringFluentImpl<IngressBackendFluent.ServicePortNested<N>> implements IngressBackendFluent.ServicePortNested<N>,Nested<N>{

            private final IntOrStringBuilder builder;
    
            ServicePortNestedImpl(){
                    this.builder = new IntOrStringBuilder(this);
            }
            ServicePortNestedImpl(IntOrString item){
                    this.builder = new IntOrStringBuilder(this, item);
            }
    
    public N and(){
            return (N) IngressBackendFluentImpl.this.withServicePort(builder.build());
    }
    public N endServicePort(){
            return and();
    }

}


}
