package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface BuildListFluent<A extends BuildListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Build... items);
    public A removeFromItems(Build... items);
    public List<Build> getItems();
    public A withItems(List<Build> items);
    public A withItems(Build... items);
    public BuildListFluent.ItemsNested<A> addNewItem();
    public BuildListFluent.ItemsNested<A> addNewItemLike(Build item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public BuildListFluent.MetadataNested<A> withNewMetadata();
    public BuildListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public BuildListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,BuildFluent<BuildListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<BuildListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
