package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Boolean;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface ClusterRoleScopeRestrictionFluent<A extends ClusterRoleScopeRestrictionFluent<A>> extends Fluent<A>{


    public Boolean isAllowEscalation();
    public A withAllowEscalation(Boolean allowEscalation);
    public A addToNamespaces(String... items);
    public A removeFromNamespaces(String... items);
    public List<String> getNamespaces();
    public A withNamespaces(List<String> namespaces);
    public A withNamespaces(String... namespaces);
    public A addToRoleNames(String... items);
    public A removeFromRoleNames(String... items);
    public List<String> getRoleNames();
    public A withRoleNames(List<String> roleNames);
    public A withRoleNames(String... roleNames);



}
