package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Long;
import java.lang.Object;

public class ImageLayerFluentImpl<A extends ImageLayerFluent<A>> extends BaseFluent<A> implements ImageLayerFluent<A>{

    private String name;
    private Long size;

    public ImageLayerFluentImpl(){
    }
    public ImageLayerFluentImpl(ImageLayer instance){
            this.withName(instance.getName()); 
            this.withSize(instance.getSize()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Long getSize(){
            return this.size;
    }

    public A withSize(Long size){
            this.size=size; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageLayerFluentImpl that = (ImageLayerFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (size != null ? !size.equals(that.size) :that.size != null) return false;
            return true;
    }




}
