/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.MetadataFile;
import io.fabric8.kubernetes.api.model.MetadataFileFluent;
import io.fabric8.kubernetes.api.model.MetadataFileFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class MetadataFileBuilder
extends MetadataFileFluentImpl<MetadataFileBuilder>
implements VisitableBuilder<MetadataFile, MetadataFileBuilder> {
    MetadataFileFluent<?> fluent;
    Boolean validationEnabled;

    public MetadataFileBuilder() {
        this(true);
    }

    public MetadataFileBuilder(Boolean validationEnabled) {
        this(new MetadataFile(), validationEnabled);
    }

    public MetadataFileBuilder(MetadataFileFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public MetadataFileBuilder(MetadataFileFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MetadataFile(), validationEnabled);
    }

    public MetadataFileBuilder(MetadataFileFluent<?> fluent, MetadataFile instance) {
        this(fluent, instance, true);
    }

    public MetadataFileBuilder(MetadataFileFluent<?> fluent, MetadataFile instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFieldRef(instance.getFieldRef());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public MetadataFileBuilder(MetadataFile instance) {
        this(instance, (Boolean)true);
    }

    public MetadataFileBuilder(MetadataFile instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFieldRef(instance.getFieldRef());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public MetadataFile build() {
        MetadataFile buildable = new MetadataFile(this.fluent.getFieldRef(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetadataFileBuilder that = (MetadataFileBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

