/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SecretBuilder
extends SecretFluentImpl<SecretBuilder>
implements VisitableBuilder<Secret, SecretBuilder> {
    SecretFluent<?> fluent;
    Boolean validationEnabled;

    public SecretBuilder() {
        this(true);
    }

    public SecretBuilder(Boolean validationEnabled) {
        this(new Secret(), validationEnabled);
    }

    public SecretBuilder(SecretFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecretBuilder(SecretFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Secret(), validationEnabled);
    }

    public SecretBuilder(SecretFluent<?> fluent, Secret instance) {
        this(fluent, instance, true);
    }

    public SecretBuilder(SecretFluent<?> fluent, Secret instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withData(instance.getData());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public SecretBuilder(Secret instance) {
        this(instance, (Boolean)true);
    }

    public SecretBuilder(Secret instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withData(instance.getData());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Secret build() {
        Secret buildable = new Secret(this.fluent.getApiVersion(), this.fluent.getData(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretBuilder that = (SecretBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

