package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class PersistentVolumeClaimStatusBuilder extends PersistentVolumeClaimStatusFluentImpl<PersistentVolumeClaimStatusBuilder> implements VisitableBuilder<PersistentVolumeClaimStatus,PersistentVolumeClaimStatusBuilder>{

    PersistentVolumeClaimStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PersistentVolumeClaimStatusBuilder(){
            this(true);
    }
    public PersistentVolumeClaimStatusBuilder(Boolean validationEnabled){
            this(new PersistentVolumeClaimStatus(), validationEnabled);
    }
    public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatusFluent<?> fluent){
            this(fluent, true);
    }
    public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PersistentVolumeClaimStatus(), validationEnabled);
    }
    public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatusFluent<?> fluent,PersistentVolumeClaimStatus instance){
            this(fluent, instance, true);
    }
    public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatusFluent<?> fluent,PersistentVolumeClaimStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccessModes(instance.getAccessModes()); 
            fluent.withCapacity(instance.getCapacity()); 
            fluent.withPhase(instance.getPhase()); 
            this.validationEnabled = validationEnabled; 
    }
    public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatus instance){
            this(instance,true);
    }
    public PersistentVolumeClaimStatusBuilder(PersistentVolumeClaimStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccessModes(instance.getAccessModes()); 
            this.withCapacity(instance.getCapacity()); 
            this.withPhase(instance.getPhase()); 
            this.validationEnabled = validationEnabled; 
    }

    public PersistentVolumeClaimStatus build(){
            PersistentVolumeClaimStatus buildable = new PersistentVolumeClaimStatus(fluent.getAccessModes(),fluent.getCapacity(),fluent.getPhase());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PersistentVolumeClaimStatusBuilder that = (PersistentVolumeClaimStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
