package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface HorizontalPodAutoscalerStatusFluent<A extends HorizontalPodAutoscalerStatusFluent<A>> extends Fluent<A>{


    public Integer getCurrentCPUUtilizationPercentage();
    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage);
    public Integer getCurrentReplicas();
    public A withCurrentReplicas(Integer currentReplicas);
    public Integer getDesiredReplicas();
    public A withDesiredReplicas(Integer desiredReplicas);
    public String getLastScaleTime();
    public A withLastScaleTime(String lastScaleTime);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);



}
