package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public class BuildConfigListFluentImpl<A extends BuildConfigListFluent<A>> extends BaseFluent<A> implements BuildConfigListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends BuildConfig,?>> items =  new ArrayList<VisitableBuilder<? extends BuildConfig,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public BuildConfigListFluentImpl(){
    }
    public BuildConfigListFluentImpl(BuildConfigList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(BuildConfig... items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(BuildConfig... items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<BuildConfig> getItems(){
            return build(items);
    }

    public A withItems(List<BuildConfig> items){
            this.items.clear();
            if (items != null) {for (BuildConfig item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(BuildConfig... items){
            this.items.clear(); if (items != null) {for (BuildConfig item :items){ this.addToItems(item);}} return (A) this;
    }

    public BuildConfigListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public BuildConfigListFluent.ItemsNested<A> addNewItemLike(BuildConfig item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public BuildConfigListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public BuildConfigListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public BuildConfigListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildConfigListFluentImpl that = (BuildConfigListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends BuildConfigFluentImpl<BuildConfigListFluent.ItemsNested<N>> implements BuildConfigListFluent.ItemsNested<N>,Nested<N>{

            private final BuildConfigBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new BuildConfigBuilder(this);
            }
            ItemsNestedImpl(BuildConfig item){
                    this.builder = new BuildConfigBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) BuildConfigListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<BuildConfigListFluent.MetadataNested<N>> implements BuildConfigListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) BuildConfigListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
