package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface LimitRangeListFluent<A extends LimitRangeListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(LimitRange... items);
    public A removeFromItems(LimitRange... items);
    public List<LimitRange> getItems();
    public A withItems(List<LimitRange> items);
    public A withItems(LimitRange... items);
    public LimitRangeListFluent.ItemsNested<A> addNewItem();
    public LimitRangeListFluent.ItemsNested<A> addNewItemLike(LimitRange item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public LimitRangeListFluent.MetadataNested<A> withNewMetadata();
    public LimitRangeListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public LimitRangeListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,LimitRangeFluent<LimitRangeListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<LimitRangeListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
