package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Integer;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class NodeDaemonEndpointsFluentImpl<A extends NodeDaemonEndpointsFluent<A>> extends BaseFluent<A> implements NodeDaemonEndpointsFluent<A>{

    private VisitableBuilder<? extends DaemonEndpoint,?> kubeletEndpoint;

    public NodeDaemonEndpointsFluentImpl(){
    }
    public NodeDaemonEndpointsFluentImpl(NodeDaemonEndpoints instance){
            this.withKubeletEndpoint(instance.getKubeletEndpoint()); 
    }

    public DaemonEndpoint getKubeletEndpoint(){
            return this.kubeletEndpoint!=null?this.kubeletEndpoint.build():null;
    }

    public A withKubeletEndpoint(DaemonEndpoint kubeletEndpoint){
            if (kubeletEndpoint!=null){ this.kubeletEndpoint= new DaemonEndpointBuilder(kubeletEndpoint); _visitables.add(this.kubeletEndpoint);} return (A) this;
    }

    public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> withNewKubeletEndpoint(){
            return new KubeletEndpointNestedImpl();
    }

    public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> withNewKubeletEndpointLike(DaemonEndpoint item){
            return new KubeletEndpointNestedImpl(item);
    }

    public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> editKubeletEndpoint(){
            return withNewKubeletEndpointLike(getKubeletEndpoint());
    }

    public A withNewKubeletEndpoint(Integer port){
            return (A)withKubeletEndpoint(new DaemonEndpoint(port));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodeDaemonEndpointsFluentImpl that = (NodeDaemonEndpointsFluentImpl) o;
            if (kubeletEndpoint != null ? !kubeletEndpoint.equals(that.kubeletEndpoint) :that.kubeletEndpoint != null) return false;
            return true;
    }


    public class KubeletEndpointNestedImpl<N> extends DaemonEndpointFluentImpl<NodeDaemonEndpointsFluent.KubeletEndpointNested<N>> implements NodeDaemonEndpointsFluent.KubeletEndpointNested<N>,Nested<N>{

            private final DaemonEndpointBuilder builder;
    
            KubeletEndpointNestedImpl(){
                    this.builder = new DaemonEndpointBuilder(this);
            }
            KubeletEndpointNestedImpl(DaemonEndpoint item){
                    this.builder = new DaemonEndpointBuilder(this, item);
            }
    
    public N and(){
            return (N) NodeDaemonEndpointsFluentImpl.this.withKubeletEndpoint(builder.build());
    }
    public N endKubeletEndpoint(){
            return and();
    }

}


}
