package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PodStatusFluent<A extends PodStatusFluent<A>> extends Fluent<A>{


    public A addToInitContainerStatuses(ContainerStatus... items);
    public A removeFromInitContainerStatuses(ContainerStatus... items);
    public List<ContainerStatus> getInitContainerStatuses();
    public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses);
    public A withInitContainerStatuses(ContainerStatus... initContainerStatuses);
    public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus();
    public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item);
    public A addToConditions(PodCondition... items);
    public A removeFromConditions(PodCondition... items);
    public List<PodCondition> getConditions();
    public A withConditions(List<PodCondition> conditions);
    public A withConditions(PodCondition... conditions);
    public PodStatusFluent.ConditionsNested<A> addNewCondition();
    public PodStatusFluent.ConditionsNested<A> addNewConditionLike(PodCondition item);
    public A addToContainerStatuses(ContainerStatus... items);
    public A removeFromContainerStatuses(ContainerStatus... items);
    public List<ContainerStatus> getContainerStatuses();
    public A withContainerStatuses(List<ContainerStatus> containerStatuses);
    public A withContainerStatuses(ContainerStatus... containerStatuses);
    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus();
    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item);
    public String getHostIP();
    public A withHostIP(String hostIP);
    public String getMessage();
    public A withMessage(String message);
    public String getPhase();
    public A withPhase(String phase);
    public String getPodIP();
    public A withPodIP(String podIP);
    public String getReason();
    public A withReason(String reason);
    public String getStartTime();
    public A withStartTime(String startTime);

    public interface InitContainerStatusesNested<N> extends Nested<N>,ContainerStatusFluent<PodStatusFluent.InitContainerStatusesNested<N>>{

        
    public N and();    public N endInitContainerStatus();
}
    public interface ConditionsNested<N> extends Nested<N>,PodConditionFluent<PodStatusFluent.ConditionsNested<N>>{

        
    public N endCondition();    public N and();
}
    public interface ContainerStatusesNested<N> extends Nested<N>,ContainerStatusFluent<PodStatusFluent.ContainerStatusesNested<N>>{

        
    public N and();    public N endContainerStatus();
}


}
