package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class HTTPIngressPathFluentImpl<A extends HTTPIngressPathFluent<A>> extends BaseFluent<A> implements HTTPIngressPathFluent<A>{

    private VisitableBuilder<? extends IngressBackend,?> backend;
    private String path;

    public HTTPIngressPathFluentImpl(){
    }
    public HTTPIngressPathFluentImpl(HTTPIngressPath instance){
            this.withBackend(instance.getBackend()); 
            this.withPath(instance.getPath()); 
    }

    public IngressBackend getBackend(){
            return this.backend!=null?this.backend.build():null;
    }

    public A withBackend(IngressBackend backend){
            if (backend!=null){ this.backend= new IngressBackendBuilder(backend); _visitables.add(this.backend);} return (A) this;
    }

    public HTTPIngressPathFluent.BackendNested<A> withNewBackend(){
            return new BackendNestedImpl();
    }

    public HTTPIngressPathFluent.BackendNested<A> withNewBackendLike(IngressBackend item){
            return new BackendNestedImpl(item);
    }

    public HTTPIngressPathFluent.BackendNested<A> editBackend(){
            return withNewBackendLike(getBackend());
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPIngressPathFluentImpl that = (HTTPIngressPathFluentImpl) o;
            if (backend != null ? !backend.equals(that.backend) :that.backend != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            return true;
    }


    public class BackendNestedImpl<N> extends IngressBackendFluentImpl<HTTPIngressPathFluent.BackendNested<N>> implements HTTPIngressPathFluent.BackendNested<N>,Nested<N>{

            private final IngressBackendBuilder builder;
    
            BackendNestedImpl(){
                    this.builder = new IngressBackendBuilder(this);
            }
            BackendNestedImpl(IngressBackend item){
                    this.builder = new IngressBackendBuilder(this, item);
            }
    
    public N and(){
            return (N) HTTPIngressPathFluentImpl.this.withBackend(builder.build());
    }
    public N endBackend(){
            return and();
    }

}


}
