package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.String;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;

public interface BuildSpecFluent<A extends BuildSpecFluent<A>> extends Fluent<A>{


    public Long getCompletionDeadlineSeconds();
    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds);
    public BuildOutput getOutput();
    public A withOutput(BuildOutput output);
    public BuildSpecFluent.OutputNested<A> withNewOutput();
    public BuildSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item);
    public BuildSpecFluent.OutputNested<A> editOutput();
    public BuildPostCommitSpec getPostCommit();
    public A withPostCommit(BuildPostCommitSpec postCommit);
    public BuildSpecFluent.PostCommitNested<A> withNewPostCommit();
    public BuildSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item);
    public BuildSpecFluent.PostCommitNested<A> editPostCommit();
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public BuildSpecFluent.ResourcesNested<A> withNewResources();
    public BuildSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public BuildSpecFluent.ResourcesNested<A> editResources();
    public SourceRevision getRevision();
    public A withRevision(SourceRevision revision);
    public BuildSpecFluent.RevisionNested<A> withNewRevision();
    public BuildSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item);
    public BuildSpecFluent.RevisionNested<A> editRevision();
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public BuildSource getSource();
    public A withSource(BuildSource source);
    public BuildSpecFluent.SourceNested<A> withNewSource();
    public BuildSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item);
    public BuildSpecFluent.SourceNested<A> editSource();
    public BuildStrategy getStrategy();
    public A withStrategy(BuildStrategy strategy);
    public BuildSpecFluent.StrategyNested<A> withNewStrategy();
    public BuildSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item);
    public BuildSpecFluent.StrategyNested<A> editStrategy();
    public A addToTriggeredBy(BuildTriggerCause... items);
    public A removeFromTriggeredBy(BuildTriggerCause... items);
    public List<BuildTriggerCause> getTriggeredBy();
    public A withTriggeredBy(List<BuildTriggerCause> triggeredBy);
    public A withTriggeredBy(BuildTriggerCause... triggeredBy);
    public BuildSpecFluent.TriggeredByNested<A> addNewTriggeredBy();
    public BuildSpecFluent.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item);

    public interface OutputNested<N> extends Nested<N>,BuildOutputFluent<BuildSpecFluent.OutputNested<N>>{

        
    public N endOutput();    public N and();
}
    public interface PostCommitNested<N> extends Nested<N>,BuildPostCommitSpecFluent<BuildSpecFluent.PostCommitNested<N>>{

        
    public N and();    public N endPostCommit();
}
    public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<BuildSpecFluent.ResourcesNested<N>>{

        
    public N and();    public N endResources();
}
    public interface RevisionNested<N> extends Nested<N>,SourceRevisionFluent<BuildSpecFluent.RevisionNested<N>>{

        
    public N endRevision();    public N and();
}
    public interface SourceNested<N> extends Nested<N>,BuildSourceFluent<BuildSpecFluent.SourceNested<N>>{

        
    public N and();    public N endSource();
}
    public interface StrategyNested<N> extends Nested<N>,BuildStrategyFluent<BuildSpecFluent.StrategyNested<N>>{

        
    public N endStrategy();    public N and();
}
    public interface TriggeredByNested<N> extends Nested<N>,BuildTriggerCauseFluent<BuildSpecFluent.TriggeredByNested<N>>{

        
    public N endTriggeredBy();    public N and();
}


}
