/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.RollingDeploymentStrategyParams;
import io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent;
import io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RollingDeploymentStrategyParamsBuilder
extends RollingDeploymentStrategyParamsFluentImpl<RollingDeploymentStrategyParamsBuilder>
implements VisitableBuilder<RollingDeploymentStrategyParams, RollingDeploymentStrategyParamsBuilder> {
    RollingDeploymentStrategyParamsFluent<?> fluent;
    Boolean validationEnabled;

    public RollingDeploymentStrategyParamsBuilder() {
        this(true);
    }

    public RollingDeploymentStrategyParamsBuilder(Boolean validationEnabled) {
        this(new RollingDeploymentStrategyParams(), validationEnabled);
    }

    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParamsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParamsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RollingDeploymentStrategyParams(), validationEnabled);
    }

    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParamsFluent<?> fluent, RollingDeploymentStrategyParams instance) {
        this(fluent, instance, true);
    }

    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParamsFluent<?> fluent, RollingDeploymentStrategyParams instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIntervalSeconds(instance.getIntervalSeconds());
        fluent.withMaxSurge(instance.getMaxSurge());
        fluent.withMaxUnavailable(instance.getMaxUnavailable());
        fluent.withPost(instance.getPost());
        fluent.withPre(instance.getPre());
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
        fluent.withUpdatePercent(instance.getUpdatePercent());
        fluent.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds());
        this.validationEnabled = validationEnabled;
    }

    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParams instance) {
        this(instance, (Boolean)true);
    }

    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParams instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIntervalSeconds(instance.getIntervalSeconds());
        this.withMaxSurge(instance.getMaxSurge());
        this.withMaxUnavailable(instance.getMaxUnavailable());
        this.withPost(instance.getPost());
        this.withPre(instance.getPre());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.withUpdatePercent(instance.getUpdatePercent());
        this.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public RollingDeploymentStrategyParams build() {
        RollingDeploymentStrategyParams buildable = new RollingDeploymentStrategyParams(this.fluent.getIntervalSeconds(), this.fluent.getMaxSurge(), this.fluent.getMaxUnavailable(), this.fluent.getPost(), this.fluent.getPre(), this.fluent.getTimeoutSeconds(), this.fluent.getUpdatePercent(), this.fluent.getUpdatePeriodSeconds());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RollingDeploymentStrategyParamsBuilder that = (RollingDeploymentStrategyParamsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

