package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ComponentStatusListFluent<A extends ComponentStatusListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ComponentStatus... items);
    public A removeFromItems(ComponentStatus... items);
    public List<ComponentStatus> getItems();
    public A withItems(List<ComponentStatus> items);
    public A withItems(ComponentStatus... items);
    public ComponentStatusListFluent.ItemsNested<A> addNewItem();
    public ComponentStatusListFluent.ItemsNested<A> addNewItemLike(ComponentStatus item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ComponentStatusListFluent.MetadataNested<A> withNewMetadata();
    public ComponentStatusListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ComponentStatusListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ComponentStatusFluent<ComponentStatusListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ComponentStatusListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
