package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SecretFluent<A extends SecretFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToData(String key,String value);
    public A addToData(Map<String,String> map);
    public A removeFromData(String key);
    public A removeFromData(Map<String,String> map);
    public Map<String,String> getData();
    public A withData(Map<String,String> data);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public SecretFluent.MetadataNested<A> withNewMetadata();
    public SecretFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public SecretFluent.MetadataNested<A> editMetadata();
    public A addToStringData(String key,String value);
    public A addToStringData(Map<String,String> map);
    public A removeFromStringData(String key);
    public A removeFromStringData(Map<String,String> map);
    public Map<String,String> getStringData();
    public A withStringData(Map<String,String> stringData);
    public String getType();
    public A withType(String type);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<SecretFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
