package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ServiceStatusFluent<A extends ServiceStatusFluent<A>> extends Fluent<A>{


    public LoadBalancerStatus getLoadBalancer();
    public A withLoadBalancer(LoadBalancerStatus loadBalancer);
    public ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancer();
    public ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStatus item);
    public ServiceStatusFluent.LoadBalancerNested<A> editLoadBalancer();

    public interface LoadBalancerNested<N> extends Nested<N>,LoadBalancerStatusFluent<ServiceStatusFluent.LoadBalancerNested<N>>{

        
    public N and();    public N endLoadBalancer();
}


}
