package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface NodeSpecFluent<A extends NodeSpecFluent<A>> extends Fluent<A>{


    public String getExternalID();
    public A withExternalID(String externalID);
    public String getPodCIDR();
    public A withPodCIDR(String podCIDR);
    public String getProviderID();
    public A withProviderID(String providerID);
    public Boolean isUnschedulable();
    public A withUnschedulable(Boolean unschedulable);



}
